/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol;

import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.util.Hierarchical;
import com.microsoft.tfs.util.Check;
import java.util.ArrayList;
import java.util.List;
import ms.tfs.versioncontrol.clientservices._03._BranchRelative;
import ms.tfs.versioncontrol.clientservices._03._Item;

public class BranchHistoryTreeItem
implements Hierarchical {
    private BranchHistoryTreeItem parent;
    private boolean isRequested;
    private List<BranchHistoryTreeItem> children = new ArrayList<BranchHistoryTreeItem>();
    private Item item;
    private Item fromItem;
    private int level = 0;
    private boolean hasRelative = false;
    private int branchToChangeTypeFlags = 0;

    public BranchHistoryTreeItem() {
    }

    public BranchHistoryTreeItem(String serverPath, int changesetId) {
        Check.notNull(serverPath, "serverPath");
        this.item = new Item();
        this.item.setServerItem(serverPath);
        this.item.setChangeSetID(changesetId);
    }

    public BranchHistoryTreeItem(_Item item) {
        if (item != null) {
            this.item = new Item(item);
        }
    }

    public static BranchHistoryTreeItem createFromRelativeToItem(_BranchRelative relative) {
        BranchHistoryTreeItem item = new BranchHistoryTreeItem(relative.getBranchToItem());
        item.isRequested = relative.isReqstd();
        item.branchToChangeTypeFlags = relative.getBctype();
        item.hasRelative = true;
        return item;
    }

    public boolean hasRelative() {
        return this.hasRelative;
    }

    public boolean isRequested() {
        return this.isRequested;
    }

    public void setRequested(boolean isRequested) {
        this.isRequested = isRequested;
    }

    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public int getBranchToChangeTypeEx() {
        return this.branchToChangeTypeFlags;
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    public BranchHistoryTreeItem getParentBranchHistoryTreeItem() {
        return this.parent;
    }

    public void setParent(BranchHistoryTreeItem parent) {
        this.parent = parent;
    }

    @Override
    public Object[] getChildren() {
        return this.children.toArray();
    }

    public List<BranchHistoryTreeItem> getChildrenAsList() {
        return this.children;
    }

    public boolean addChild(BranchHistoryTreeItem child) {
        return this.children.add(child);
    }

    @Override
    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setChildren(List<BranchHistoryTreeItem> children) {
        this.children = children;
    }

    public Item getFromItem() {
        return this.fromItem;
    }

    public void setFromItem(Item fromItem) {
        this.fromItem = fromItem;
    }

    public String getServerItem() {
        return this.item == null ? "" : this.item.getServerItem();
    }

    public int getFromItemChangesetID() {
        return this.fromItem == null ? 0 : this.fromItem.getChangeSetID();
    }

    public int hashCode() {
        return this.getServerItem().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BranchHistoryTreeItem other = (BranchHistoryTreeItem)obj;
        return this.getServerItem().equals(other);
    }

    protected BranchHistoryTreeItem searchForRequestedItem() {
        if (this.isRequested()) {
            return this;
        }
        for (BranchHistoryTreeItem child : this.children) {
            BranchHistoryTreeItem requestedItem = child.searchForRequestedItem();
            if (requestedItem == null) continue;
            return requestedItem;
        }
        return null;
    }
}

