/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.IPopulatableLocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyConstants;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyUtils;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLocalItem;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.datetime.DotNETDate;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ClientLocalVersionUpdate
implements IPopulatableLocalVersionUpdate {
    private static final Log log = LogFactory.getLog(ClientLocalVersionUpdate.class);
    private static final byte[] ZERO_LENGTH_BYTE_ARRAY = new byte[0];
    private final String sourceServerItem;
    private final int itemID;
    private final String targetLocalItem;
    private final int versionLocal;
    private long versionLocalDate = -1L;
    private int encoding = 0;
    private byte[] baselineHashValue = null;
    private long baselineFileLength = -1L;
    private byte[] baselineFileGuid = null;
    private boolean keepLocalVersionEntryOnDelete = false;
    private long lastModifiedDate = -1L;
    private String pendingChangeTargetServerItem = null;
    private String downloadURL = null;
    private PropertyValue[] properties;

    public ClientLocalVersionUpdate(String sourceServerItem, int itemID, String targetLocalItem, int versionLocal, PropertyValue[] properties) {
        Check.isTrue(versionLocal >= -1, "versionLocal");
        this.sourceServerItem = sourceServerItem;
        this.itemID = itemID;
        this.targetLocalItem = targetLocalItem;
        this.versionLocal = versionLocal;
        this.properties = properties;
    }

    public ClientLocalVersionUpdate(String sourceServerItem, int itemID, String targetLocalItem, int versionLocal, int encoding, boolean keepLocalVersionRowOnDelete, PropertyValue[] properties) {
        this(sourceServerItem, itemID, targetLocalItem, versionLocal, properties);
        this.encoding = encoding;
        this.keepLocalVersionEntryOnDelete = keepLocalVersionRowOnDelete;
    }

    public ClientLocalVersionUpdate(String sourceServerItem, int itemID, String targetLocalItem, int versionLocal, Calendar versionLocalDate, int encoding, byte[] baselineHashValue, long baselineFileLength, byte[] baselineFileGuid, String pendingChangeTargetServerItem, PropertyValue[] properties) {
        this(sourceServerItem, itemID, targetLocalItem, versionLocal, properties);
        Check.isTrue(0 != encoding || null == pendingChangeTargetServerItem, "0 != encoding || null == pendingChangeTargetServerItem");
        this.versionLocalDate = DotNETDate.MIN_CALENDAR.equals(versionLocalDate) ? -1L : DotNETDate.toWindowsFileTimeUTC(versionLocalDate);
        this.encoding = encoding;
        this.baselineHashValue = baselineHashValue;
        this.baselineFileLength = baselineFileLength;
        this.baselineFileGuid = baselineFileGuid;
        this.pendingChangeTargetServerItem = pendingChangeTargetServerItem;
    }

    @Override
    public boolean isSendToServer() {
        return true;
    }

    @Override
    public boolean isCommitted() {
        return this.versionLocal != 0;
    }

    @Override
    public boolean isFullyPopulated(boolean requireLocalVersionDate) {
        if (null == this.targetLocalItem) {
            return true;
        }
        if (0 == this.encoding || -2 == this.encoding) {
            return false;
        }
        if (-3 == this.encoding || 0 == this.versionLocal && null == this.pendingChangeTargetServerItem) {
            return true;
        }
        if (0 != this.versionLocal && requireLocalVersionDate && -1L == this.versionLocalDate) {
            return false;
        }
        return null != this.baselineHashValue && 16 == this.baselineHashValue.length && -1L != this.baselineFileLength;
    }

    @Override
    public void updateFrom(Item item) {
        Check.isTrue(0 != this.versionLocal, "Attempted to update a ClientLocalVersionUpdate for an uncommitted item");
        this.encoding = item.getEncoding().getCodePage();
        if (-3 != this.encoding) {
            this.baselineFileLength = item.getContentLength();
            this.baselineHashValue = item.getContentHashValue();
            this.versionLocalDate = DotNETDate.MIN_CALENDAR.equals(item.getCheckinDate()) ? -1L : DotNETDate.toWindowsFileTimeUTC(item.getCheckinDate());
        }
    }

    @Override
    public void updateFrom(WorkspaceLocalItem lvExisting) {
        boolean isSymlink;
        Check.isTrue(ServerPath.equals(this.sourceServerItem, lvExisting.getServerItem()) && this.versionLocal == lvExisting.getVersion(), "ServerPath.equals(sourceServerItem, lvExisting.getServerItem()) && versionLocal == lvExisting.getVersion()");
        if (0 == this.encoding || -2 == this.encoding) {
            this.encoding = lvExisting.getEncoding();
        } else if (0 != this.versionLocal) {
            Check.isTrue(this.encoding == lvExisting.getEncoding(), "encoding == lvExisting.getEncoding()");
        }
        if (-1L == this.versionLocalDate) {
            this.versionLocalDate = lvExisting.getCheckinDate();
        }
        boolean bl = isSymlink = PropertyConstants.IS_SYMLINK.equals(PropertyUtils.selectMatching(lvExisting.getPropertyValues(), "Microsoft.TeamFoundation.VersionControl.SymbolicLink")) || PropertyConstants.IS_SYMLINK.equals(PropertyUtils.selectMatching(this.properties, "Microsoft.TeamFoundation.VersionControl.SymbolicLink"));
        if (isSymlink) {
            this.baselineFileLength = 0L;
        }
        if (-1L == this.baselineFileLength) {
            this.baselineFileLength = lvExisting.getLength();
        } else if (-1L != lvExisting.getLength() && !isSymlink && 0 != this.versionLocal && this.baselineFileLength != lvExisting.getLength()) {
            String logMessage = MessageFormat.format("The server file: {0} is out of sync with the local version: {1}", this.getSourceServerItem(), this.getTargetLocalItem());
            log.error((Object)logMessage);
            String errorMessage = MessageFormat.format(Messages.getString("ClientLocalVersionUpdate.ErrorLengthOutOfSyncFormat"), this.getSourceServerItem(), this.getTargetLocalItem());
            Check.isTrue(false, errorMessage);
        }
        if (null == this.baselineHashValue || 16 != this.baselineHashValue.length) {
            this.baselineHashValue = lvExisting.getHashValue();
        } else if (lvExisting.hasHashValue() && 0 != this.versionLocal) {
            Check.isTrue(Arrays.equals(this.baselineHashValue, lvExisting.getHashValue()), "Arrays.equals(baselineHashValue, lvExisting.getHashValue())");
        }
        if (null == this.baselineFileGuid || 16 != this.baselineFileGuid.length) {
            this.baselineFileGuid = lvExisting.getBaselineFileGUID();
        }
    }

    @Override
    public void updateFrom(PendingChange pendingChange) {
        Check.isTrue(this.versionLocal == pendingChange.getVersion(), "versionLocal == pendingChange.getVersion()");
        Check.isTrue(0 != this.encoding, "0 != encoding");
        this.baselineFileLength = pendingChange.getLength();
        this.baselineHashValue = pendingChange.getHashValue();
    }

    public void generateNewBaselineFileGUID() {
        Check.isTrue(null == this.baselineFileGuid && -3 != this.encoding && (0 != this.versionLocal || null != this.downloadURL), "null == baselineFileGuid && VersionControlConstants.ENCODING_FOLDER != encoding && (0 != versionLocal || null != downloadURL)");
        this.baselineFileGuid = GUID.newGUID().getGUIDBytes();
    }

    @Override
    public String getSourceServerItem() {
        return this.sourceServerItem;
    }

    @Override
    public int getItemID() {
        return this.itemID;
    }

    @Override
    public String getTargetLocalItem() {
        return this.targetLocalItem;
    }

    @Override
    public int getVersionLocal() {
        return this.versionLocal;
    }

    public long getVersionLocalDate() {
        return this.versionLocalDate;
    }

    public int getEncoding() {
        return this.encoding;
    }

    @Override
    public byte[] getBaselineHashValue() {
        if (null == this.baselineHashValue || 16 != this.baselineHashValue.length) {
            return ZERO_LENGTH_BYTE_ARRAY;
        }
        return this.baselineHashValue;
    }

    public long getBaselineFileLength() {
        return this.baselineFileLength;
    }

    @Override
    public byte[] getBaselineFileGUID() {
        return this.baselineFileGuid;
    }

    public boolean getKeepLocalVersionEntryOnDelete() {
        return this.keepLocalVersionEntryOnDelete;
    }

    @Override
    public String getPendingChangeTargetServerItem() {
        return this.pendingChangeTargetServerItem;
    }

    @Override
    public String getDownloadURL() {
        return this.downloadURL;
    }

    @Override
    public void setDownloadURL(String value) {
        this.downloadURL = value;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(long value) {
        this.lastModifiedDate = value;
    }

    public PropertyValue[] getPropertyValues() {
        return this.properties;
    }

    public void setPropertyValues(PropertyValue[] properties) {
        this.properties = properties;
    }
}

