/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol;

import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.CheckinNote;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.CheckinNoteFieldValue;
import java.util.Arrays;
import java.util.HashMap;

public abstract class GatedCheckinUtils {
    public static boolean gatedCheckinNotesMatch(CheckinNote committedCheckinNotes, CheckinNote pendingCheckinNotes) {
        if (null == pendingCheckinNotes && null == committedCheckinNotes) {
            return true;
        }
        if (null == pendingCheckinNotes) {
            for (CheckinNoteFieldValue committedNote : committedCheckinNotes.getValues()) {
                if (committedNote.getValue() == null || committedNote.getValue().length() <= 0) continue;
                return false;
            }
            return true;
        }
        if (null == committedCheckinNotes) {
            for (CheckinNoteFieldValue pendingNote : pendingCheckinNotes.getValues()) {
                if (pendingNote.getValue() == null || pendingNote.getValue().length() <= 0) continue;
                return false;
            }
            return false;
        }
        HashMap<String, String> pendingFields = new HashMap<String, String>();
        for (CheckinNoteFieldValue pendingNote : pendingCheckinNotes.getValues()) {
            pendingFields.put(pendingNote.getName(), pendingNote.getValue());
        }
        for (CheckinNoteFieldValue committedNote : committedCheckinNotes.getValues()) {
            boolean containsNoteKey = pendingFields.containsKey(committedNote.getName());
            if (containsNoteKey) {
                String pendingValue = (String)pendingFields.get(committedNote.getName());
                String committedValue = committedNote.getValue();
                if (!(pendingValue == null && committedValue != null && committedValue.length() > 0 || committedValue == null && pendingValue != null && pendingValue.length() > 0) && (pendingValue == null || committedValue == null || pendingValue.equals(committedValue))) continue;
                return false;
            }
            if (committedNote.getValue() == null || committedNote.getValue().length() <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean gatedCheckinCommentsMatch(String committedComment, String pendingComment) {
        if (null == committedComment) {
            committedComment = "";
        }
        if (null == pendingComment) {
            pendingComment = "";
        }
        committedComment = committedComment.trim();
        pendingComment = pendingComment.trim();
        if (committedComment.endsWith("***NO_CI***")) {
            committedComment = committedComment.substring(0, committedComment.lastIndexOf("***NO_CI***"));
        }
        return committedComment.trim().equals(pendingComment);
    }

    public static boolean gatedCheckinWorkItemsMatch(int[] committedWorkItemIds, int[] pendingWorkItemIds) {
        if (null == committedWorkItemIds) {
            return false;
        }
        if (null == pendingWorkItemIds) {
            return committedWorkItemIds.length == 0;
        }
        if (pendingWorkItemIds.length != committedWorkItemIds.length) {
            return false;
        }
        if (pendingWorkItemIds.length == 0 || committedWorkItemIds.length == 0) {
            return true;
        }
        int[] committedCopy = (int[])committedWorkItemIds.clone();
        int[] pendingCopy = (int[])pendingWorkItemIds.clone();
        Arrays.sort(committedCopy);
        Arrays.sort(pendingCopy);
        return Arrays.equals(committedCopy, pendingCopy);
    }
}

