/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol;

import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.internal.MergeOptions;
import com.microsoft.tfs.util.BitField;

public class MergeFlags
extends BitField {
    public static final MergeFlags NONE = new MergeFlags(0, "None");
    public static final MergeFlags FORCE_MERGE = new MergeFlags(1, "ForceMerge");
    public static final MergeFlags BASELESS = new MergeFlags(2, "Baseless");
    public static final MergeFlags NO_MERGE = new MergeFlags(16, "NoMerge");
    public static final MergeFlags ALWAYS_ACCEPT_MINE = new MergeFlags(32, "AlwaysAcceptMine");
    public static final MergeFlags SILENT = new MergeFlags(64, "Silent");
    public static final MergeFlags NO_IMPLICIT_BASELESS = new MergeFlags(128, "NoImplicitBaseless");
    public static final MergeFlags CONSERVATIVE = new MergeFlags(256, "Conservative");
    public static final MergeFlags NO_AUTO_RESOLVE = new MergeFlags(512, "NoAutoResolve");

    public static MergeFlags combine(MergeFlags[] values) {
        return new MergeFlags(BitField.combine(values));
    }

    private MergeFlags(int flags, String name) {
        super(flags);
        MergeFlags.registerStringValue(this.getClass(), flags, name);
    }

    private MergeFlags(int flags) {
        super(flags);
    }

    public MergeOptions toMergeOptions() {
        MergeOptions options = new MergeOptions();
        if (this.contains(ALWAYS_ACCEPT_MINE)) {
            options.add(MergeOptions.ALWAYS_ACCEPT_MINE);
        }
        if (this.contains(BASELESS)) {
            options.add(MergeOptions.BASELESS);
        }
        if (this.contains(FORCE_MERGE)) {
            options.add(MergeOptions.FORCE_MERGE);
        }
        if (this.contains(NO_MERGE)) {
            options.add(MergeOptions.NO_MERGE);
        }
        if (options.size() == 0) {
            return new MergeOptions(MergeOptions.NONE);
        }
        return options;
    }

    public boolean containsAll(MergeFlags other) {
        return this.containsAllInternal(other);
    }

    public boolean contains(MergeFlags other) {
        return this.containsInternal(other);
    }

    public boolean containsAny(MergeFlags other) {
        return this.containsAnyInternal(other);
    }

    public MergeFlags remove(MergeFlags other) {
        return new MergeFlags(this.removeInternal(other));
    }

    public MergeFlags retain(MergeFlags other) {
        return new MergeFlags(this.retainInternal(other));
    }

    public MergeFlags combine(MergeFlags other) {
        return new MergeFlags(this.combineInternal(other));
    }
}

