/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol;

import com.microsoft.tfs.core.clients.security.AccessControlEntry;
import com.microsoft.tfs.core.clients.security.AccessControlEntryDetails;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspacePermissions;
import com.microsoft.tfs.core.clients.webservices.GroupWellKnownSIDConstants;
import com.microsoft.tfs.core.clients.webservices.IdentityDescriptor;
import com.microsoft.tfs.util.Check;
import java.util.ArrayList;

public class WorkspacePermissionProfile {
    public static final String BUILTIN_PROFILE_NAME_PRIVATE = "Private";
    public static final String BUILTIN_PROFILE_NAME_PUBLIC_LIMITED = "PublicLimited";
    public static final String BUILTIN_PROFILE_NAME_PUBLIC = "Public";
    public static final int BUILTIN_PROFILE_INDEX_PRIVATE = 0;
    public static final int BUILTIN_PROFILE_INDEX_PUBLIC_LIMITED = 1;
    public static final int BUILTIN_PROFILE_INDEX_PUBLIC = 2;
    private static WorkspacePermissionProfile[] BUILTIN_PROFILES;
    private static final Object BUILTIN_PROFILES_LOCK;
    private final AccessControlEntry[] accessControlEntries;
    private final String name;
    private int builtinIndex = -1;

    public WorkspacePermissionProfile(String profileName, AccessControlEntry[] accessControlEntries) {
        Check.notNullOrEmpty(profileName, "profileName");
        Check.notNull(accessControlEntries, "accessControlEntries");
        this.name = profileName;
        this.accessControlEntries = accessControlEntries;
    }

    public AccessControlEntry[] getAccessControlEntries() {
        return this.accessControlEntries;
    }

    public String getName() {
        return this.name;
    }

    public int getBuiltinIndex() {
        return this.builtinIndex;
    }

    private void setBuiltinIndex(int value) {
        this.builtinIndex = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkspacePermissionProfile[] getBuiltInProfiles() {
        Object object = BUILTIN_PROFILES_LOCK;
        synchronized (object) {
            if (BUILTIN_PROFILES == null) {
                IdentityDescriptor everyoneGroup = new IdentityDescriptor("Microsoft.TeamFoundation.Identity", GroupWellKnownSIDConstants.EVERYONE_GROUP_SID);
                ArrayList<WorkspacePermissionProfile> profiles = new ArrayList<WorkspacePermissionProfile>();
                profiles.add(new WorkspacePermissionProfile(BUILTIN_PROFILE_NAME_PRIVATE, new AccessControlEntry[0]));
                WorkspacePermissions publicLimitedPermissions = WorkspacePermissions.USE.combine(WorkspacePermissions.READ);
                AccessControlEntryDetails publicLimitedEntry = new AccessControlEntryDetails(everyoneGroup, publicLimitedPermissions.toIntFlags(), WorkspacePermissions.NONE_OR_NOT_SUPPORTED.toIntFlags());
                profiles.add(new WorkspacePermissionProfile(BUILTIN_PROFILE_NAME_PUBLIC_LIMITED, new AccessControlEntry[]{publicLimitedEntry}));
                WorkspacePermissions publicPermissions = WorkspacePermissions.ADMINISTER.combine(WorkspacePermissions.CHECK_IN.combine(WorkspacePermissions.USE.combine(WorkspacePermissions.READ)));
                AccessControlEntryDetails publicEntry = new AccessControlEntryDetails(everyoneGroup, publicPermissions.toIntFlags(), WorkspacePermissions.NONE_OR_NOT_SUPPORTED.toIntFlags());
                profiles.add(new WorkspacePermissionProfile(BUILTIN_PROFILE_NAME_PUBLIC, new AccessControlEntry[]{publicEntry}));
                for (int i = 0; i < profiles.size(); ++i) {
                    ((WorkspacePermissionProfile)profiles.get(i)).setBuiltinIndex(i);
                }
                BUILTIN_PROFILES = profiles.toArray(new WorkspacePermissionProfile[profiles.size()]);
            }
            return BUILTIN_PROFILES;
        }
    }

    public static WorkspacePermissionProfile getPrivateProfile() {
        return WorkspacePermissionProfile.getBuiltInProfiles()[0];
    }

    public static WorkspacePermissionProfile getPublicLimitedProfile() {
        return WorkspacePermissionProfile.getBuiltInProfiles()[1];
    }

    public static WorkspacePermissionProfile getPublicProfile() {
        return WorkspacePermissionProfile.getBuiltInProfiles()[2];
    }

    static {
        BUILTIN_PROFILES_LOCK = new Object();
    }
}

