/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.conflicts;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictCategory;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictDescriptionStrings;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.VersionConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolution;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolutionOptions;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.CoreConflictResolution;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.contributors.ConflictResolutionContributor;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Resolution;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import java.text.MessageFormat;
import java.util.ArrayList;

public class RollbackLocalConflictDescription
extends VersionConflictDescription {
    protected RollbackLocalConflictDescription(Workspace workspace, Conflict conflict, ItemSpec[] conflictItemSpecs) {
        super(workspace, conflict, conflictItemSpecs);
    }

    @Override
    public ConflictCategory getConflictCategory() {
        return ConflictCategory.ROLLBACK_LOCAL;
    }

    @Override
    public String getName() {
        return Messages.getString("RollbackLocalConflictDescription.Name");
    }

    @Override
    public String getDescription() {
        return Messages.getString("RollbackLocalConflictDescription.Description");
    }

    @Override
    public ConflictResolution[] getResolutions(ConflictResolutionContributor conflictResolutionContributor) {
        ArrayList<ConflictResolution> resolutionList = new ArrayList<ConflictResolution>();
        Conflict conflict = this.getConflict();
        ConflictResolutionOptions resolutionOptions = ConflictResolutionOptions.NONE;
        if (this.filesRenamed() && this.isEncodingChange()) {
            resolutionOptions = ConflictResolutionOptions.SELECT_NAME.combine(ConflictResolutionOptions.SELECT_ENCODING);
            resolutionList.add(new CoreConflictResolution(this, ConflictDescriptionStrings.RENAME_ENCODING_AND_AUTOMERGE, ConflictDescriptionStrings.RENAME_ENCODING_AND_AUTOMERGE_TOOLTIP, resolutionOptions, Resolution.ACCEPT_MERGE));
        } else if (this.filesRenamedOnly()) {
            resolutionList.add(new CoreConflictResolution(this, ConflictDescriptionStrings.RENAME, ConflictDescriptionStrings.RENAME_TOOLTIP, ConflictResolutionOptions.SELECT_NAME, Resolution.ACCEPT_MERGE));
        } else if (this.filesRenamed()) {
            resolutionList.add(new CoreConflictResolution(this, ConflictDescriptionStrings.RENAME_AND_AUTOMERGE, ConflictDescriptionStrings.RENAME_AND_AUTOMERGE_TOOLTIP, ConflictResolutionOptions.SELECT_NAME, Resolution.ACCEPT_MERGE));
            resolutionOptions = ConflictResolutionOptions.SELECT_NAME;
        } else if (this.isEncodingChange()) {
            resolutionList.add(new CoreConflictResolution(this, MessageFormat.format(ConflictDescriptionStrings.SELECT_ENCODING_AND_AUTOMERGE, this.getLocalFileDescription(), this.getRemoteFileDescription()), ConflictDescriptionStrings.SELECT_ENCODING_AND_AUTOMERGE_TOOLTIP, ConflictResolutionOptions.SELECT_ENCODING, Resolution.ACCEPT_MERGE));
            resolutionOptions = ConflictResolutionOptions.SELECT_ENCODING;
        } else if (conflict != null && !conflict.getBaseChangeType().containsAll(ChangeType.ROLLBACK.combine(ChangeType.DELETE))) {
            resolutionList.add(new CoreConflictResolution(this, ConflictDescriptionStrings.AUTOMERGE, MessageFormat.format(ConflictDescriptionStrings.AUTOMERGE_TOOLTIP, this.getLocalFileDescription(), this.getRemoteFileDescription()), ConflictResolutionOptions.NONE, Resolution.ACCEPT_MERGE));
        }
        if (!this.filesRenamedOnly() && conflictResolutionContributor != null) {
            resolutionList.addAll(this.loadContributedResolutions(conflictResolutionContributor, resolutionOptions));
        }
        resolutionList.add(new CoreConflictResolution(this, ConflictDescriptionStrings.ROLLBACK_LOCAL_ACCEPT_YOURS, ConflictDescriptionStrings.ROLLBACK_LOCAL_ACCEPT_YOURS_TOOLTIP, ConflictResolutionOptions.NONE, Resolution.ACCEPT_YOURS));
        resolutionList.add(new CoreConflictResolution(this, ConflictDescriptionStrings.ROLLBACK_LOCAL_ACCEPT_THEIRS, ConflictDescriptionStrings.ROLLBACK_LOCAL_ACCEPT_THEIRS_TOOLTIP, ConflictResolutionOptions.NONE, Resolution.ACCEPT_THEIRS));
        return resolutionList.toArray(new ConflictResolution[resolutionList.size()]);
    }
}

