/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.contributors;

import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolution;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolutionOptions;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.contributors.ConflictResolutionContributor;
import com.microsoft.tfs.util.Check;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CompositeConflictResolutionContributor
implements ConflictResolutionContributor {
    private final List<ConflictResolutionContributor> contributors = new ArrayList<ConflictResolutionContributor>();

    public CompositeConflictResolutionContributor() {
    }

    public CompositeConflictResolutionContributor(ConflictResolutionContributor[] subContributors) {
        Check.notNull(subContributors, "subContributors");
        this.addContributors(subContributors);
    }

    public void addContributor(ConflictResolutionContributor subContributor) {
        Check.notNull(subContributor, "subContributor");
        this.contributors.add(subContributor);
    }

    public void addContributors(ConflictResolutionContributor[] subContributors) {
        Check.notNull(subContributors, "subContributor");
        for (int i = 0; i < subContributors.length; ++i) {
            this.addContributor(subContributors[i]);
        }
    }

    @Override
    public Collection<ConflictResolution> getConflictResolutions(ConflictDescription conflictDescription, ConflictResolutionOptions resolutionOptions) {
        ArrayList<ConflictResolution> resolutions = new ArrayList<ConflictResolution>();
        for (ConflictResolutionContributor contributor : this.contributors) {
            Collection<ConflictResolution> contributorResolutions = contributor.getConflictResolutions(conflictDescription, resolutionOptions);
            if (contributorResolutions == null) continue;
            resolutions.addAll(contributorResolutions);
        }
        return resolutions;
    }
}

