/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.engines.internal;

import com.microsoft.tfs.core.clients.versioncontrol.ChangePendedFlags;
import com.microsoft.tfs.core.clients.versioncontrol.ClientLocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.GetOptions;
import com.microsoft.tfs.core.clients.versioncontrol.GetStatus;
import com.microsoft.tfs.core.clients.versioncontrol.ILocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.InitiallyDeletedLocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.MoveUncommittedLocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.OperationStatus;
import com.microsoft.tfs.core.clients.versioncontrol.ProcessType;
import com.microsoft.tfs.core.clients.versioncontrol.UpdateLocalVersionQueue;
import com.microsoft.tfs.core.clients.versioncontrol.UpdateLocalVersionQueueOptions;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.AsyncOperation;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.RetryEntry;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.WorkerStatus;
import com.microsoft.tfs.core.clients.versioncontrol.internal.concurrent.AccountingCompletionService;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BaselineFolderCollection;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLock;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetOperation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RequestType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.util.Check;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class AsyncGetOperation
extends AsyncOperation
implements Closeable {
    private final ProcessType type;
    private final GetOptions options;
    private final GetStatus getStatus;
    private final Workspace workspace;
    private final WorkspaceLock workspaceLock;
    private final boolean deleteUndoneAdds;
    private final ChangePendedFlags flags;
    private final AccountingCompletionService<WorkerStatus> completionService;
    private final Map<String, GetOperation> existingLocalHash = Collections.synchronizedMap(new TreeMap(LocalPath.TOP_DOWN_COMPARATOR));
    private final Map<String, GetOperation> dontDeleteFolderHash = Collections.synchronizedMap(new TreeMap(LocalPath.TOP_DOWN_COMPARATOR));
    private final SortedMap<String, GetOperation> deletes = Collections.synchronizedSortedMap(new TreeMap(LocalPath.BOTTOM_UP_COMPARATOR));
    private final UpdateLocalVersionQueue localUpdateQueue;
    private final UpdateLocalVersionQueueOptions localUpdateOptions;
    private final List<RetryEntry> retryList = Collections.synchronizedList(new ArrayList());
    public volatile int currentNumOperations;
    public volatile int totalNumOperations;

    public AsyncGetOperation(Workspace workspace, ProcessType type, RequestType requestType, GetOptions options, boolean deleteUndoneAdds, WorkspaceLock wLock, UpdateLocalVersionQueueOptions localUpdateOptions, ChangePendedFlags flags, AccountingCompletionService<WorkerStatus> completionService) {
        Check.notNull(workspace, "workspace");
        Check.notNull(type, "type");
        Check.notNull(requestType, "requestType");
        Check.notNull(options, "options");
        Check.notNull(localUpdateOptions, "localUpdateOptions");
        Check.notNull(flags, "flags");
        Check.notNull(completionService, "completionService");
        this.type = type;
        this.getStatus = new GetStatus();
        this.workspace = workspace;
        this.options = options;
        this.localUpdateOptions = localUpdateOptions;
        this.localUpdateQueue = new UpdateLocalVersionQueue(workspace, localUpdateOptions, wLock);
        this.workspaceLock = wLock;
        this.deleteUndoneAdds = deleteUndoneAdds;
        this.flags = flags;
        this.completionService = completionService;
    }

    @Override
    public void close() {
        if (this.localUpdateQueue != null) {
            this.localUpdateQueue.close();
        }
    }

    public ProcessType getType() {
        return this.type;
    }

    public GetOptions getOptions() {
        return this.options;
    }

    public GetStatus getStatus() {
        return this.getStatus;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public UpdateLocalVersionQueueOptions getLocalUpdateOptions() {
        return this.localUpdateOptions;
    }

    public Map<String, GetOperation> getExistingLocalHash() {
        return this.existingLocalHash;
    }

    public Map<String, GetOperation> getDontDeleteFolderHash() {
        return this.dontDeleteFolderHash;
    }

    public SortedMap<String, GetOperation> getDeletes() {
        return this.deletes;
    }

    public List<RetryEntry> getRetryList() {
        return this.retryList;
    }

    public void queueLocalVersionUpdate(GetOperation operation, String targetLocalPath, int version) throws IllegalStateException {
        this.queueLocalVersionUpdate(operation, targetLocalPath, version, false);
    }

    public void queueLocalVersionUpdate(GetOperation operation, String targetLocalItem, int version, boolean force) throws IllegalStateException {
        String sourceLocalPath = operation.getSourceLocalItem();
        if (force || version != operation.getVersionLocal() || targetLocalItem == null && sourceLocalPath != null || targetLocalItem != null && !targetLocalItem.equals(operation.getSourceLocalItem())) {
            boolean keepLocalVersionRowOnDelete;
            boolean bl = keepLocalVersionRowOnDelete = !operation.isUndo() && !operation.getChangeType().equals(ChangeType.NONE);
            if (keepLocalVersionRowOnDelete && null == operation.getSourceLocalItem() && null == operation.getTargetLocalItem()) {
                this.localUpdateQueue.queueUpdate(new InitiallyDeletedLocalVersionUpdate(operation.getSourceServerItem(), operation.getItemID(), operation.getVersionServer(), operation.getVersionServerDate(), operation.getEncoding(), operation.getTargetServerItem()));
            } else {
                if (0 == version && 0 == operation.getVersionLocal() && null != operation.getSourceLocalItem() && !LocalPath.equals(operation.getSourceLocalItem(), operation.getTargetLocalItem())) {
                    this.localUpdateQueue.queueUpdate(new MoveUncommittedLocalVersionUpdate(operation.getSourceServerItem(), operation.getSourceLocalItem()));
                }
                this.localUpdateQueue.queueUpdate(new ClientLocalVersionUpdate(operation.getSourceServerItem(), operation.getItemID(), targetLocalItem, version, operation.getEncoding(), keepLocalVersionRowOnDelete, operation.getPropertyValues()));
            }
            this.getStatus.incrementNumUpdated();
        }
    }

    public void queueLocalVersionUpdate(ILocalVersionUpdate update) {
        Check.notNull(update, "update");
        this.localUpdateQueue.queueUpdate(update);
        this.getStatus.incrementNumUpdated();
    }

    public void resetForRetry() {
        this.retryList.clear();
    }

    public void addConflict(GetOperation action) {
        this.getStatus.incrementNumConflicts();
    }

    public void addWarning(OperationStatus status, GetOperation op) {
        this.addWarning(status, op, null);
    }

    public void addWarning(OperationStatus status, GetOperation op, GetOperation targetAction) {
        this.retryList.add(new RetryEntry(status, op, targetAction));
    }

    public boolean isPreview() {
        return this.options.contains(GetOptions.PREVIEW);
    }

    public boolean isGetAll() {
        return this.options.contains(GetOptions.GET_ALL);
    }

    public boolean isOverwrite() {
        return this.options.contains(GetOptions.OVERWRITE);
    }

    public boolean isNoDiskUpdate() {
        return this.options.contains(GetOptions.NO_DISK_UPDATE);
    }

    public boolean getDeleteUndoneAdds() {
        return this.deleteUndoneAdds;
    }

    public ChangePendedFlags getFlags() {
        return this.flags;
    }

    public AccountingCompletionService<WorkerStatus> getCompletionService() {
        return this.completionService;
    }

    public WorkspaceLock getWorkspaceLock() {
        return this.workspaceLock;
    }

    public BaselineFolderCollection getBaselineFolders() {
        if (null == this.workspaceLock) {
            return null;
        }
        return this.workspaceLock.getBaselineFolders();
    }

    public UpdateLocalVersionQueue getLocalUpdateQueue() {
        return this.localUpdateQueue;
    }
}

