/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.engines.internal;

import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.BaseDownloadOutput;
import com.microsoft.tfs.util.Check;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputStreamDownloadOutput
extends BaseDownloadOutput {
    private static final Log log = LogFactory.getLog(OutputStreamDownloadOutput.class);
    private final OutputStream outputStream;

    public OutputStreamDownloadOutput(OutputStream outputStream, boolean autoGunzip) {
        super(autoGunzip);
        Check.notNull(outputStream, "outputStream");
        this.outputStream = outputStream;
    }

    @Override
    public synchronized OutputStream getOutputStream() throws FileNotFoundException {
        return this.outputStream;
    }

    @Override
    public synchronized void resetOutputStream() throws IOException {
        throw new IOException(MessageFormat.format("{0} does not support reset", OutputStreamDownloadOutput.class.getName()));
    }

    @Override
    public void closeOutputStream() throws IOException {
        this.outputStream.close();
    }
}

