/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalPendingChangesTable;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceProperties;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceVersionTable;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.LocalMetadataTable;
import com.microsoft.tfs.util.GUID;
import java.lang.ref.WeakReference;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class OfflineCacheData {
    private final Map<Class, WeakReference<LocalMetadataTable>> metadataTableCache;
    private final Map<Class, LocalMetadataTable> strongMetadataTableCache;
    private boolean stronglyRootMetadataTables;
    private GUID lastServerPendingChangeSignature = GUID.EMPTY;
    private Calendar lastReconcileTime = Calendar.getInstance();

    public OfflineCacheData() {
        this.metadataTableCache = new HashMap<Class, WeakReference<LocalMetadataTable>>();
        this.strongMetadataTableCache = new HashMap<Class, LocalMetadataTable>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheMetadataTable(LocalMetadataTable toCache) {
        OfflineCacheData offlineCacheData = this;
        synchronized (offlineCacheData) {
            Class<?> c = toCache.getClass();
            this.metadataTableCache.put(c, new WeakReference<LocalMetadataTable>(toCache));
            if (this.stronglyRootMetadataTables) {
                this.strongMetadataTableCache.put(c, toCache);
            }
        }
    }

    public boolean isStronglyRootMetadataTables() {
        return this.stronglyRootMetadataTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStronglyRootMetadataTables(boolean value) {
        OfflineCacheData offlineCacheData = this;
        synchronized (offlineCacheData) {
            if (!value && this.stronglyRootMetadataTables) {
                this.strongMetadataTableCache.clear();
                this.stronglyRootMetadataTables = false;
            } else if (value && !this.stronglyRootMetadataTables) {
                for (Class key : this.metadataTableCache.keySet()) {
                    LocalMetadataTable table = (LocalMetadataTable)this.metadataTableCache.get(key).get();
                    if (null == table) continue;
                    this.strongMetadataTableCache.put(key, table);
                }
                this.stronglyRootMetadataTables = true;
            }
        }
    }

    public LocalWorkspaceProperties getCachedLocalWorkspaceProperties() {
        return (LocalWorkspaceProperties)this.getCachedMetadataTable(LocalWorkspaceProperties.class);
    }

    public WorkspaceVersionTable getCachedWorkspaceVersionTable() {
        return (WorkspaceVersionTable)this.getCachedMetadataTable(WorkspaceVersionTable.class);
    }

    public LocalPendingChangesTable getCachedLocalPendingChangesTable() {
        return (LocalPendingChangesTable)this.getCachedMetadataTable(LocalPendingChangesTable.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalMetadataTable getCachedMetadataTable(Class<? extends LocalMetadataTable> c) {
        OfflineCacheData offlineCacheData = this;
        synchronized (offlineCacheData) {
            if (this.stronglyRootMetadataTables) {
                LocalMetadataTable table = this.strongMetadataTableCache.get(c);
                if (table != null) {
                    if (table.isEligibleForCachedLoad()) {
                        return table;
                    }
                    this.strongMetadataTableCache.remove(c);
                    this.metadataTableCache.remove(c);
                }
            } else if (this.metadataTableCache.containsKey(c)) {
                WeakReference<LocalMetadataTable> weakReference = this.metadataTableCache.get(c);
                LocalMetadataTable table = (LocalMetadataTable)weakReference.get();
                if (null != table && table.isEligibleForCachedLoad()) {
                    return table;
                }
                this.metadataTableCache.remove(c);
            }
        }
        return null;
    }

    public GUID getLastServerPendingChangeSignature() {
        return this.lastServerPendingChangeSignature;
    }

    public void setLastServerPendingChangeSignature(GUID value) {
        this.lastServerPendingChangeSignature = value;
    }

    public Calendar getLastReconcileTime() {
        return this.lastReconcileTime;
    }

    public void setLastReconcileTime(Calendar value) {
        this.lastReconcileTime = value;
    }
}

