/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.CommittedState;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLocalItem;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLocalItemPair;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceVersionTable;
import com.microsoft.tfs.core.clients.versioncontrol.path.ItemPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.EnumSubTreeOptions;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.EnumeratedSparseTreeNode;
import com.microsoft.tfs.util.NotYetImplementedException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class WorkspaceLocalItemEnumerable
implements Iterator<WorkspaceLocalItem>,
Iterable<WorkspaceLocalItem> {
    private WorkspaceLocalItem current;
    private WorkspaceLocalItem onDeck;
    private final MoveNextDelegate moveNextDelegate;
    private Iterator<EnumeratedSparseTreeNode<WorkspaceLocalItem>> localEnumerator;
    private Iterator<EnumeratedSparseTreeNode<WorkspaceLocalItemPair>> serverEnumerator;
    private String pattern;
    private final boolean includeDeleted;
    private CommittedState committedState;

    public WorkspaceLocalItemEnumerable(WorkspaceVersionTable lv, RecursionType recursion, String localItem, String pattern, boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        this.pattern = "*" == pattern ? null : pattern;
        EnumSubTreeOptions options = EnumSubTreeOptions.NONE;
        if (pattern == null) {
            options = EnumSubTreeOptions.ENUMERATE_SUB_TREE_ROOT;
        }
        int depth = WorkspaceLocalItemEnumerable.depthFromRecursionType(recursion);
        this.localEnumerator = lv.local.EnumSubTree(localItem, options, depth).iterator();
        this.moveNextDelegate = new MoveNextDelegate(){

            @Override
            public boolean invoke() {
                return WorkspaceLocalItemEnumerable.this.localItemMoveNext();
            }
        };
    }

    public WorkspaceLocalItemEnumerable(WorkspaceVersionTable lv, RecursionType recursion, String serverItem, CommittedState committedState, String pattern, boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        this.pattern = "*" == pattern ? null : pattern;
        this.committedState = committedState;
        EnumSubTreeOptions options = EnumSubTreeOptions.NONE;
        if (pattern == null) {
            options = EnumSubTreeOptions.ENUMERATE_SUB_TREE_ROOT;
        }
        int depth = WorkspaceLocalItemEnumerable.depthFromRecursionType(recursion);
        this.serverEnumerator = lv.server.EnumSubTree(serverItem, options, depth).iterator();
        this.moveNextDelegate = new MoveNextDelegate(){

            @Override
            public boolean invoke() {
                return WorkspaceLocalItemEnumerable.this.serverItemMoveNext();
            }
        };
    }

    boolean moveNext() {
        return this.moveNextDelegate.invoke();
    }

    private boolean localItemMoveNext() {
        while (this.localEnumerator.hasNext()) {
            boolean includeDeletedCondition;
            EnumeratedSparseTreeNode<WorkspaceLocalItem> currentItem = this.localEnumerator.next();
            boolean patternCondition = null == this.pattern || ItemPath.matchesWildcardFile(LocalPath.getFileName(currentItem.token), this.pattern);
            boolean bl = includeDeletedCondition = this.includeDeleted || !((WorkspaceLocalItem)currentItem.referencedObject).isDeleted();
            if (!patternCondition || !includeDeletedCondition) continue;
            this.current = (WorkspaceLocalItem)currentItem.referencedObject;
            return true;
        }
        this.current = null;
        return false;
    }

    private boolean serverItemMoveNext() {
        if (null != this.onDeck) {
            this.current = this.onDeck;
            this.onDeck = null;
            return true;
        }
        while (this.serverEnumerator.hasNext()) {
            EnumeratedSparseTreeNode<WorkspaceLocalItemPair> currentItem = this.serverEnumerator.next();
            if (null != this.pattern && !ItemPath.matchesWildcardFile(ServerPath.getFileName(currentItem.token), this.pattern)) continue;
            this.current = null;
            WorkspaceLocalItemPair pair = (WorkspaceLocalItemPair)currentItem.referencedObject;
            if (null != pair.getCommitted() && this.committedState.contains(CommittedState.COMMITTED)) {
                WorkspaceLocalItem committed = pair.getCommitted();
                if (this.includeDeleted || !committed.isDeleted()) {
                    this.current = committed;
                }
            }
            if (null != pair.getUncommitted() && this.committedState.contains(CommittedState.UNCOMMITTED)) {
                WorkspaceLocalItem uncommitted = pair.getUncommitted();
                if (this.includeDeleted || !uncommitted.isDeleted()) {
                    if (null == this.current) {
                        this.current = uncommitted;
                    } else {
                        this.onDeck = uncommitted;
                    }
                }
            }
            if (null == this.current) continue;
            return true;
        }
        this.current = null;
        return false;
    }

    @Override
    public Iterator<WorkspaceLocalItem> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.current != null) {
            return true;
        }
        return this.moveNext();
    }

    @Override
    public WorkspaceLocalItem next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        WorkspaceLocalItem toReturn = this.current;
        this.moveNext();
        return toReturn;
    }

    @Override
    public void remove() {
        throw new NotYetImplementedException();
    }

    private static int depthFromRecursionType(RecursionType recursion) {
        if (recursion == RecursionType.NONE) {
            return 0;
        }
        if (recursion == RecursionType.ONE_LEVEL) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    private static interface MoveNextDelegate {
        public boolean invoke();
    }
}

