/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BaselineFolderCollection;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceProperties;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspacePropertiesTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.LocalMetadataTableLock;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.util.Check;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WorkspaceLock {
    private static final Log log = LogFactory.getLog(WorkspaceLock.class);
    private static ThreadLocal<WorkspaceLock> current = new ThreadLocal();
    private final WorkspaceLock previousWorkspaceLock;
    private final Workspace workspace;
    private final Thread creationThread;
    private final boolean previousStronglyRootSetting;
    private volatile LocalMetadataTableLock lock;
    private volatile ReentrantReadWriteLock rwLock;
    private volatile BaselineFolderCollection baselineFolders;

    public WorkspaceLock(Workspace workspace) {
        this(workspace, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkspaceLock(Workspace workspace, boolean requestYield) {
        Check.notNull(workspace, "workspace");
        this.workspace = workspace;
        this.creationThread = Thread.currentThread();
        boolean success = false;
        try {
            this.lock = new LocalMetadataTableLock(workspace.getLocalMetadataDirectory(), requestYield);
            this.previousWorkspaceLock = current.get();
            current.set(this);
            this.previousStronglyRootSetting = workspace.getOfflineCacheData().isStronglyRootMetadataTables();
            workspace.getOfflineCacheData().setStronglyRootMetadataTables(true);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    public void close() {
        Check.isTrue(this.creationThread == Thread.currentThread(), "A different thread is disposing a workspace lock than the one that created it.");
        current.set(this.previousWorkspaceLock);
        Throwable throwable = null;
        try {
            if (this.lock != null) {
                this.lock.close();
                this.lock = null;
            }
        }
        catch (Throwable t) {
            if (throwable == null) {
                throwable = t;
            }
            log.error((Object)"Error unlocking metadata tables", t);
        }
        try {
            this.workspace.getOfflineCacheData().setStronglyRootMetadataTables(this.previousStronglyRootSetting);
        }
        catch (Throwable t) {
            if (throwable == null) {
                throwable = t;
            }
            log.error((Object)"Error resetting strongly root metadata tables", t);
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable != null) {
            throw new RuntimeException(MessageFormat.format("Error closing {0} for workspace {1}", this.getClass().getName(), this.workspace), throwable);
        }
    }

    public boolean isYieldRequested() {
        return this.lock.isYieldRequested();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void yield() {
        block16: {
            if (this.lock.isYieldRequested()) {
                this.getTransactionLock().writeLock().lock();
                try {
                    int writeLockToken = 0;
                    if (null != this.getBaselineFolders()) {
                        writeLockToken = this.getBaselineFolders().lockForWrite();
                    }
                    try {
                        this.lock.yield();
                        if (null == this.getBaselineFolders()) break block16;
                        LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(this.workspace, this);
                        try {
                            transaction.execute(new WorkspacePropertiesTransaction(){

                                @Override
                                public void invoke(LocalWorkspaceProperties wp) {
                                    WorkspaceLock.this.getBaselineFolders().updateFrom(wp.getBaselineFolders());
                                }
                            });
                        }
                        finally {
                            try {
                                transaction.close();
                            }
                            catch (IOException e) {
                                throw new VersionControlException(e);
                            }
                        }
                    }
                    finally {
                        if (0 != writeLockToken) {
                            this.getBaselineFolders().unlockForWrite(writeLockToken);
                        }
                    }
                }
                finally {
                    this.getTransactionLock().writeLock().unlock();
                }
            }
        }
    }

    public void startTransaction() {
        if (!this.getTransactionLock().isWriteLockedByCurrentThread()) {
            this.getTransactionLock().readLock().lock();
        }
    }

    public void endTransaction() {
        if (!this.getTransactionLock().isWriteLockedByCurrentThread()) {
            this.getTransactionLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantReadWriteLock getTransactionLock() {
        if (null == this.rwLock) {
            LocalMetadataTableLock localMetadataTableLock = this.lock;
            synchronized (localMetadataTableLock) {
                if (null == this.rwLock) {
                    this.rwLock = new ReentrantReadWriteLock();
                }
            }
        }
        return this.rwLock;
    }

    public static WorkspaceLock getCurrent() {
        return current.get();
    }

    public BaselineFolderCollection getBaselineFolders() {
        return this.baselineFolders;
    }

    public void setBaselineFolders(BaselineFolderCollection baselineFolders) {
        this.baselineFolders = baselineFolders;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }
}

