/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Change;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import ms.tfs.versioncontrol.clientservices._03._ChangeType;
import ms.tfs.versioncontrol.clientservices._03._ChangesetVersionSpec;
import ms.tfs.versioncontrol.clientservices._03._ItemIdentifier;

public class ItemIdentifier
extends WebServiceObjectWrapper {
    public ItemIdentifier(_ItemIdentifier webServiceObject) {
        super(webServiceObject);
    }

    public _ItemIdentifier getWebServiceObject() {
        return (_ItemIdentifier)this.webServiceObject;
    }

    public ItemIdentifier(Change change) {
        this(new _ItemIdentifier(change.getItem().getServerItem(), change.getItem().getDeletionID(), change.getChangeType().toIntFlags(), new _ChangesetVersionSpec(change.getItem().getChangeSetID())));
    }

    public ItemIdentifier(String serverPath) {
        this(serverPath, 0);
    }

    public ItemIdentifier(String serverPath, int deletionID) {
        this(serverPath, null, deletionID);
    }

    public ItemIdentifier(String serverPath, VersionSpec version, int deletionID) {
        this(new _ItemIdentifier(serverPath, deletionID, ChangeType.NONE.toIntFlags(), version == null ? null : version.getWebServiceObject()));
    }

    public String getItem() {
        return this.getWebServiceObject().getIt();
    }

    public VersionSpec getVersion() {
        return VersionSpec.fromWebServiceObject(this.getWebServiceObject().getVersion());
    }

    public int getDeletionID() {
        return this.getWebServiceObject().getDi();
    }

    public ChangeType getChangeType() {
        return new ChangeType(new _ChangeType(), this.getWebServiceObject().getCtype());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof ItemIdentifier)) {
            return false;
        }
        ItemIdentifier other = (ItemIdentifier)o;
        if (!ServerPath.equals(this.getItem(), other.getItem())) {
            return false;
        }
        if (this.getDeletionID() != other.getDeletionID()) {
            return false;
        }
        VersionSpec thisVersion = this.getVersion();
        VersionSpec otherVersion = other.getVersion();
        if (thisVersion != null || otherVersion != null) {
            if (thisVersion == null || otherVersion == null) {
                return false;
            }
            if (!thisVersion.toString().equals(otherVersion.toString())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = result * 37 + this.getItem().hashCode();
        result = result * 37 + this.getDeletionID();
        result = result * 37 + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        return result;
    }
}

