/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.internal.wrappers.EnumerationWrapper;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.HashMap;
import ms.tfs.versioncontrol.clientservices._03._LockLevel;

public class LockLevel
extends EnumerationWrapper {
    public static final HashMap<Byte, LockLevel> VALUE_MAP = new HashMap();
    public static final LockLevel NONE = new LockLevel(_LockLevel.None, 0);
    public static final LockLevel CHECKIN = new LockLevel(_LockLevel.Checkin, 1);
    public static final LockLevel CHECKOUT = new LockLevel(_LockLevel.CheckOut, 2);
    public static final LockLevel UNCHANGED = new LockLevel(_LockLevel.Unchanged, 3);
    private final byte value;

    private LockLevel(_LockLevel lockLevel, byte value) {
        super(lockLevel);
        this.value = value;
        Byte key = new Byte(value);
        Check.isTrue(!VALUE_MAP.containsKey(key), "duplicate key");
        VALUE_MAP.put(key, this);
    }

    public static LockLevel fromByteValue(byte value) {
        Byte key = new Byte(value);
        Check.isTrue(VALUE_MAP.containsKey(key), "value");
        return VALUE_MAP.get(key);
    }

    public static LockLevel fromWebServiceObject(_LockLevel webServiceObject) {
        return (LockLevel)EnumerationWrapper.fromWebServiceObject(webServiceObject);
    }

    public _LockLevel getWebServiceObject() {
        return (_LockLevel)this.webServiceObject;
    }

    public byte getValue() {
        return this.value;
    }

    public String toUIString() {
        if (this == NONE) {
            return Messages.getString("LockLevel.None");
        }
        if (this == CHECKIN) {
            return Messages.getString("LockLevel.Checkin");
        }
        if (this == CHECKOUT) {
            return Messages.getString("LockLevel.CheckOut");
        }
        if (this == UNCHANGED) {
            return Messages.getString("LockLevel.Unchanged");
        }
        throw new RuntimeException(MessageFormat.format("Unknown LockLevel {0}", this.toString()));
    }

    public String toShortUIString() {
        if (this == NONE) {
            return " ";
        }
        if (this == CHECKIN) {
            return Messages.getString("LockLevel.LockCheckinShort");
        }
        if (this == CHECKOUT) {
            return Messages.getString("LockLevel.LockCheckOutShort");
        }
        if (this == UNCHANGED) {
            return " ";
        }
        throw new RuntimeException(MessageFormat.format("Unknown LockLevel {0}", this.toString()));
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

