/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolder;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolderComparatorType;
import com.microsoft.tfs.util.Check;
import java.util.Comparator;

public final class WorkingFolderComparator
implements Comparator<WorkingFolder> {
    private final WorkingFolderComparatorType sortType;

    public WorkingFolderComparator(WorkingFolderComparatorType sortType) {
        Check.notNull(sortType, "sortType");
        this.sortType = sortType;
    }

    @Override
    public int compare(WorkingFolder first, WorkingFolder second) {
        if (this.sortType == WorkingFolderComparatorType.SERVER_PATH) {
            return ServerPath.compareTopDown(first.getServerItem(), second.getServerItem());
        }
        if (this.sortType == WorkingFolderComparatorType.SERVER_PATH_REVERSE) {
            return ServerPath.compareBottomUp(first.getServerItem(), second.getServerItem());
        }
        if (this.sortType == WorkingFolderComparatorType.LOCAL_PATH) {
            String firstLocal = first.getLocalItem();
            String secondLocal = second.getLocalItem();
            if (firstLocal == null || secondLocal == null) {
                if (firstLocal == null && secondLocal == null) {
                    return 0;
                }
                return firstLocal == null ? -1 : 1;
            }
            return LocalPath.compareTopDown(firstLocal, secondLocal);
        }
        throw new RuntimeException("Unsupported sort type");
    }
}

