/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.category;

import com.microsoft.tfs.core.clients.workitem.category.CategoryMemberCollection;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.WorkItemTypeCategoryMemberMetadata;
import com.microsoft.tfs.core.clients.workitem.wittype.WorkItemType;
import com.microsoft.tfs.core.clients.workitem.wittype.WorkItemTypeCollection;
import com.microsoft.tfs.util.Check;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CategoryMemberCollectionImpl
implements CategoryMemberCollection {
    private final Map<Integer, List<WorkItemType>> map = new HashMap<Integer, List<WorkItemType>>();

    public CategoryMemberCollectionImpl(WITContext context, WorkItemTypeCollection workItemTypes) {
        WorkItemTypeCategoryMemberMetadata[] membersMetadata;
        for (WorkItemTypeCategoryMemberMetadata member : membersMetadata = context.getMetadata().getWorkItemTypeCategoryMembersTable().getCategoryMembers()) {
            int categoryID = member.getCategoryID();
            WorkItemType workItemType = workItemTypes.get(member.getWorkItemTypeID());
            if (!this.map.containsKey(categoryID)) {
                this.map.put(categoryID, new ArrayList());
            }
            this.map.get(categoryID).add(workItemType);
        }
    }

    @Override
    public WorkItemType[] getCategoryMembers(int categoryID) {
        List<WorkItemType> list = this.map.get(categoryID);
        Check.notNull(list, "must have members for work item type category");
        return list.toArray(new WorkItemType[list.size()]);
    }
}

