/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.form;

import com.microsoft.tfs.core.clients.workitem.form.WIFormLinksControlWITypeFilter;
import com.microsoft.tfs.core.clients.workitem.form.WIFormLinksControlWITypeFilterEnum;
import com.microsoft.tfs.core.clients.workitem.form.WIFormLinksControlWITypeFilterScopeEnum;
import com.microsoft.tfs.core.clients.workitem.form.WIFormLinksControlWITypeFilters;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormElementImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormLinksControlWITypeFilterEnumFactory;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormLinksControlWITypeFilterScopeEnumFactory;
import org.xml.sax.Attributes;

public class WIFormLinksControlWITypeFiltersImpl
extends WIFormElementImpl
implements WIFormLinksControlWITypeFilters {
    private WIFormLinksControlWITypeFilter[] filters;
    private WIFormLinksControlWITypeFilterScopeEnum scope;
    private WIFormLinksControlWITypeFilterEnum filterType;

    @Override
    void startLoading(Attributes attributes) {
        this.scope = WIFormLinksControlWITypeFilterScopeEnumFactory.fromType(attributes.getValue("Scope"));
        this.filterType = WIFormLinksControlWITypeFilterEnumFactory.fromType(attributes.getValue("FilterType"));
        this.setAttributes(attributes);
    }

    @Override
    void endLoading() {
        this.filters = (WIFormLinksControlWITypeFilter[])this.childrenToArray(new WIFormLinksControlWITypeFilter[0]);
    }

    @Override
    public WIFormLinksControlWITypeFilter[] getFilters() {
        return this.filters;
    }

    @Override
    public WIFormLinksControlWITypeFilterEnum getFilter() {
        return this.filterType;
    }

    @Override
    public WIFormLinksControlWITypeFilterScopeEnum getScope() {
        return this.scope;
    }

    @Override
    public String createFilterWIQLQuery(int[] candidateWorkItemIds, String projectName) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT [System.Id] FROM WorkItems WHERE [System.Id] IN (");
        for (i = 0; i < candidateWorkItemIds.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(candidateWorkItemIds[i]);
        }
        sb.append(") AND [System.WorkItemType] ");
        if (this.filterType == WIFormLinksControlWITypeFilterEnum.EXCLUDE) {
            sb.append("NOT ");
        }
        sb.append("IN (");
        for (i = 0; i < this.filters.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'");
            sb.append(this.filters[i].getWorkItemType());
            sb.append("'");
        }
        sb.append(")");
        if (this.scope == WIFormLinksControlWITypeFilterScopeEnum.PROJECT) {
            sb.append(" AND [System.TeamProject] = '");
            sb.append(projectName);
            sb.append("'");
        }
        return sb.toString();
    }

    @Override
    public boolean includes(String workItemTypeName) {
        if (this.filterType.equals(WIFormLinksControlWITypeFilterEnum.INCLUDEALL)) {
            return true;
        }
        if (this.filterType.equals(WIFormLinksControlWITypeFilterEnum.EXCLUDE)) {
            WIFormLinksControlWITypeFilter filter = this.getFilterForTypeName(workItemTypeName);
            return filter == null;
        }
        WIFormLinksControlWITypeFilter filter = this.getFilterForTypeName(workItemTypeName);
        return filter != null;
    }

    private WIFormLinksControlWITypeFilter getFilterForTypeName(String workItemTypeName) {
        for (int i = 0; i < this.filters.length; ++i) {
            WIFormLinksControlWITypeFilter filter = this.filters[i];
            if (!filter.getWorkItemType().equalsIgnoreCase(workItemTypeName)) continue;
            return filter;
        }
        return null;
    }
}

