/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.link;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.workitem.WorkItemClient;
import com.microsoft.tfs.core.clients.workitem.internal.WorkItemImpl;
import com.microsoft.tfs.core.clients.workitem.internal.link.DescriptionUpdateRunnable;
import com.microsoft.tfs.core.clients.workitem.internal.link.LinkCollectionChangedListener;
import com.microsoft.tfs.core.clients.workitem.internal.link.LinkCollectionChangedListenerSupport;
import com.microsoft.tfs.core.clients.workitem.internal.link.LinkDescriptionUpdater;
import com.microsoft.tfs.core.clients.workitem.internal.link.LinkDescriptionUpdaterFactory;
import com.microsoft.tfs.core.clients.workitem.internal.link.LinkImpl;
import com.microsoft.tfs.core.clients.workitem.internal.link.RelatedLinkImpl;
import com.microsoft.tfs.core.clients.workitem.internal.links.WITComponentCollection;
import com.microsoft.tfs.core.clients.workitem.link.DescriptionUpdateErrorCallback;
import com.microsoft.tfs.core.clients.workitem.link.DescriptionUpdateFinishedCallback;
import com.microsoft.tfs.core.clients.workitem.link.Link;
import com.microsoft.tfs.core.clients.workitem.link.LinkCollection;
import com.microsoft.tfs.core.clients.workitem.link.RelatedLink;
import com.microsoft.tfs.core.clients.workitem.link.WorkItemLinkTypeEnd;
import com.microsoft.tfs.core.clients.workitem.link.WorkItemLinkTypeEndCollection;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class LinkCollectionImpl
extends WITComponentCollection<Link>
implements LinkCollection {
    LinkCollectionChangedListenerSupport listeners;
    Set<String> hashFieldReferenceNames = new HashSet<String>();

    public LinkCollectionImpl(WorkItemImpl workItem) {
        super(workItem);
        this.listeners = new LinkCollectionChangedListenerSupport(this);
        this.hashFieldReferenceNames.add("system.id");
        this.hashFieldReferenceNames.add("system.title");
    }

    @Override
    public Iterator<Link> iterator() {
        return this.getComponentSet().iterator();
    }

    @Override
    public int size() {
        return this.getComponentSet().size();
    }

    @Override
    public boolean contains(Link link) {
        return this.containsEquivalent((LinkImpl)link);
    }

    @Override
    public boolean add(Link link) {
        if (link instanceof RelatedLink && ((RelatedLink)link).getTargetWorkItemID() == this.getWorkItemInternal().getID()) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("LinkCollectionImpl.LinkingAWorkItemToItselfNotAllowedFormat"), Integer.toString(this.getWorkItemInternal().getID())));
        }
        boolean added = this.addComponent((LinkImpl)link);
        if (added) {
            this.listeners.fireLinkAdded(link);
        }
        return added;
    }

    @Override
    public void remove(Link link) {
        this.removeComponent((LinkImpl)link);
        this.listeners.fireLinkRemoved(link);
    }

    public void linkTargetsUpdated() {
        this.listeners.fireLinkTargetsUpdated();
    }

    public Link[] getLinks() {
        return (Link[])this.getPublicComponents(new Link[0]);
    }

    public void mergeColumnFieldReferences(String[] fieldReferences) {
        for (int i = 0; i < fieldReferences.length; ++i) {
            String fieldReference = fieldReferences[i].toLowerCase();
            if (this.hashFieldReferenceNames.contains(fieldReference)) continue;
            this.hashFieldReferenceNames.add(fieldReference);
        }
    }

    public boolean allDescriptionsComputed() {
        Link[] displayLinks = this.getLinks();
        for (int i = 0; i < displayLinks.length; ++i) {
            if (((LinkImpl)displayLinks[i]).isDescriptionComputed()) continue;
            return false;
        }
        return true;
    }

    public Runnable getDescriptionUpdateRunnable(DescriptionUpdateErrorCallback errorCallback, DescriptionUpdateFinishedCallback finishedCallback) {
        HashMap linkTypeToUpdater = new HashMap();
        String[] fieldReferenceNames = this.hashFieldReferenceNames.toArray(new String[this.hashFieldReferenceNames.size()]);
        Link[] displayLinks = this.getLinks();
        for (int i = 0; i < displayLinks.length; ++i) {
            if (((LinkImpl)displayLinks[i]).isDescriptionComputed()) continue;
            Class<?> type = displayLinks[i].getClass();
            LinkDescriptionUpdater updater = (LinkDescriptionUpdater)linkTypeToUpdater.get(type);
            if (updater == null) {
                updater = LinkDescriptionUpdaterFactory.getDescriptionUpdater(type, fieldReferenceNames, errorCallback, this.getWorkItemInternal().getContext());
                linkTypeToUpdater.put(type, updater);
            }
            updater.addLinkToBeUpdated((LinkImpl)displayLinks[i]);
        }
        return new DescriptionUpdateRunnable(errorCallback, finishedCallback, linkTypeToUpdater.values());
    }

    public void addLinkCollectionChangedListener(LinkCollectionChangedListener listener) {
        this.listeners.addListener(listener);
    }

    public void removeLinkCollectionChangedListener(LinkCollectionChangedListener listener) {
        this.listeners.removeListener(listener);
    }

    public void copy(LinkCollectionImpl targetCollection) {
        WorkItemClient client = targetCollection.getWorkItem().getClient();
        for (Link link : this.getComponentSet()) {
            LinkImpl newLink;
            if (link.isNewlyCreated()) continue;
            if (link instanceof RelatedLinkImpl) {
                WorkItemLinkTypeEndCollection ends;
                WorkItemLinkTypeEnd end;
                RelatedLinkImpl relatedLink = (RelatedLinkImpl)link;
                if (client.supportsWorkItemLinkTypes() && (end = (ends = client.getLinkTypes().getLinkTypeEnds()).getByID(relatedLink.getWorkItemLinkTypeID())).getLinkType().isOneToMany() && end.isForwardLink()) continue;
                newLink = relatedLink.cloneLink();
                ((RelatedLink)((Object)newLink)).setSourceWorkItem(targetCollection.getWorkItem());
            } else {
                newLink = ((LinkImpl)link).cloneLink();
            }
            targetCollection.add(newLink);
        }
    }
}

