/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.query;

import com.microsoft.tfs.core.clients.workitem.internal.query.WorkItemRelation;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LinkQueryResultParser {
    private final Element messageElement;

    public LinkQueryResultParser(Element messageElement) {
        this.messageElement = messageElement;
    }

    public WorkItemRelation[] parse() {
        ArrayList<WorkItemRelation> results = new ArrayList<WorkItemRelation>();
        int lastSourceID = 0;
        int lastTargetID = 0;
        int lastLinkType = 0;
        boolean lastEnumValue = false;
        NodeList childNodes = this.messageElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String enumValue;
            String linkType;
            String targetId;
            int curIx;
            String eAtt;
            String sAtt;
            Element child = (Element)childNodes.item(i);
            if (child.getNodeName().equalsIgnoreCase("S")) {
                int start;
                lastTargetID = 0;
                lastLinkType = 0;
                lastEnumValue = false;
                sAtt = child.getAttribute("S");
                eAtt = child.getAttribute("E");
                if (sAtt == null || sAtt.length() == 0) continue;
                int end = start = Integer.parseInt(sAtt);
                if (eAtt != null && eAtt.length() > 0) {
                    end = Integer.parseInt(eAtt);
                }
                for (curIx = start; curIx <= end; ++curIx) {
                    results.add(this.createWorkItemRelation(curIx, lastTargetID, lastLinkType, lastEnumValue));
                }
                lastSourceID = end;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("T")) {
                int start;
                lastSourceID = 0;
                lastEnumValue = false;
                sAtt = child.getAttribute("S");
                eAtt = child.getAttribute("E");
                if (sAtt == null || sAtt.length() == 0) continue;
                int end = start = Integer.parseInt(sAtt);
                if (eAtt != null && eAtt.length() > 0) {
                    end = Integer.parseInt(eAtt);
                }
                for (curIx = start; curIx <= end; ++curIx) {
                    results.add(this.createWorkItemRelation(lastSourceID, curIx, lastLinkType, lastEnumValue));
                }
                lastTargetID = end;
                continue;
            }
            String sourceId = child.getAttribute("S");
            if (sourceId != null && sourceId.length() > 0) {
                lastSourceID = Integer.parseInt(sourceId);
            }
            if ((targetId = child.getAttribute("T")) != null && targetId.length() > 0) {
                lastTargetID = Integer.parseInt(targetId);
            }
            if ((linkType = child.getAttribute("L")) != null && linkType.length() > 0) {
                lastLinkType = Integer.parseInt(linkType);
            }
            if ((enumValue = child.getAttribute("E")) != null && enumValue.length() > 0) {
                lastEnumValue = Integer.parseInt(enumValue) == 1;
            }
            results.add(this.createWorkItemRelation(lastSourceID, lastTargetID, lastLinkType, lastEnumValue));
        }
        return results.toArray(new WorkItemRelation[results.size()]);
    }

    private WorkItemRelation createWorkItemRelation(int sourceId, int targetId, int linkType, boolean enumValue) {
        if (sourceId == 0 || targetId == 0) {
            linkType = 0;
            enumValue = false;
        }
        return new WorkItemRelation(sourceId, targetId, linkType, enumValue);
    }
}

