/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.query;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.workitem.WorkItemClient;
import com.microsoft.tfs.core.clients.workitem.exceptions.DuplicateBatchReadParameterException;
import com.microsoft.tfs.core.clients.workitem.exceptions.ValidationException;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.query.DisplayFieldListImpl;
import com.microsoft.tfs.core.clients.workitem.internal.query.LinkQueryResultParser;
import com.microsoft.tfs.core.clients.workitem.internal.query.QueryResultParser;
import com.microsoft.tfs.core.clients.workitem.internal.query.SortFieldListImpl;
import com.microsoft.tfs.core.clients.workitem.internal.query.WorkItemCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.query.WorkItemRelation;
import com.microsoft.tfs.core.clients.workitem.internal.query.WorkItemRelationComparator;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.LinkQueryXMLResult;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeAndOperator;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeSelect;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Parser;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.SyntaxException;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.WIQLAdapter;
import com.microsoft.tfs.core.clients.workitem.link.WorkItemLinkTypeEnd;
import com.microsoft.tfs.core.clients.workitem.link.WorkItemLinkTypeEndCollection;
import com.microsoft.tfs.core.clients.workitem.query.BatchReadParameterCollection;
import com.microsoft.tfs.core.clients.workitem.query.DisplayFieldList;
import com.microsoft.tfs.core.clients.workitem.query.InvalidQueryTextException;
import com.microsoft.tfs.core.clients.workitem.query.Query;
import com.microsoft.tfs.core.clients.workitem.query.SortFieldList;
import com.microsoft.tfs.core.clients.workitem.query.SortType;
import com.microsoft.tfs.core.clients.workitem.query.WorkItemCollection;
import com.microsoft.tfs.core.clients.workitem.query.WorkItemLinkInfo;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.LinkQueryMode;
import com.microsoft.tfs.core.exceptions.NotSupportedException;
import com.microsoft.tfs.core.ws.runtime.serialization.ElementDeserializable;
import com.microsoft.tfs.core.ws.runtime.types.AnyContentType;
import com.microsoft.tfs.core.ws.runtime.types.DOMAnyContentType;
import com.microsoft.tfs.core.ws.runtime.types.StaxAnyContentType;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.xml.DOMSerializeUtils;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import ms.tfs.workitemtracking.clientservices._03._ClientService2Soap_QueryWorkitemsResponse;
import ms.tfs.workitemtracking.clientservices._03._ClientService3Soap_QueryWorkitemsResponse;
import ms.tfs.workitemtracking.clientservices._03._ClientService5Soap_QueryWorkitemsResponse;
import ms.tfs.workitemtracking.clientservices._03._QuerySortOrderEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class QueryImpl
implements Query {
    private static final Log log = LogFactory.getLog(QueryImpl.class);
    private static final String NEWLINE = System.getProperty("line.separator");
    private WITContext witContext;
    private int[] batchIds;
    private int[] batchRevs;
    private DisplayFieldListImpl displayFieldList;
    private SortFieldListImpl sortFieldList;
    private NodeSelect wiqlNode;
    private Date queryAsOf;
    private Element queryXML;
    private NodeAndOperator linkGroup;

    public QueryImpl(WITContext witContext, String queryText) {
        this.initialize(witContext, queryText, null, null, null, true);
    }

    public QueryImpl(WITContext witContext, String queryText, BatchReadParameterCollection batchReadParams) {
        int[] ids = new int[batchReadParams.getSize()];
        int[] revs = new int[batchReadParams.getSize()];
        for (int i = 0; i < batchReadParams.getSize(); ++i) {
            ids[i] = batchReadParams.getParameter(i).getID();
            revs[i] = batchReadParams.getParameter(i).getRev();
        }
        this.initialize(witContext, queryText, null, ids, revs, true);
    }

    public QueryImpl(WITContext witContext, String queryText, Map<String, Object> queryContext) {
        this.initialize(witContext, queryText, queryContext, null, null, true);
    }

    public QueryImpl(WITContext witContext, String queryText, Map<String, Object> queryContext, boolean dayPrecision) {
        this.initialize(witContext, queryText, queryContext, null, null, dayPrecision);
    }

    public QueryImpl(WITContext witContext, String queryText, int[] ids, int[] revs) {
        this.initialize(witContext, queryText, null, this.copyArray(ids), this.copyArray(revs), true);
    }

    public QueryImpl(WITContext witContext, String queryText, int[] ids) {
        this.initialize(witContext, queryText, null, this.copyArray(ids), null, true);
    }

    @Override
    public DisplayFieldList getDisplayFieldList() {
        return this.displayFieldList;
    }

    @Override
    public SortFieldList getSortFieldList() {
        if (this.isBatchReadMode()) {
            throw new IllegalStateException("sort field list is invalid for a parameterized query");
        }
        return this.sortFieldList;
    }

    @Override
    public WorkItemCollection runQuery() {
        if (this.isBatchReadMode()) {
            return this.runBatchReadQuery();
        }
        return this.runNormalQuery();
    }

    @Override
    public boolean isLinkQuery() {
        return ((LinkQueryMode)this.wiqlNode.getFrom().getTag()).getValue() > LinkQueryMode.WORK_ITEMS.getValue();
    }

    @Override
    public boolean isTreeQuery() {
        return this.wiqlNode.getFrom().getTag() == LinkQueryMode.LINKS_RECURSIVE;
    }

    @Override
    public boolean isBatchReadMode() {
        return this.batchIds != null;
    }

    @Override
    public WorkItemLinkInfo[] runLinkQuery() {
        Calendar asOfDate;
        AnyContentType resultIds;
        String dbStamp;
        AnyContentType metadata;
        ElementDeserializable response;
        DOMAnyContentType psQuery = new DOMAnyContentType(new Element[]{this.queryXML});
        if (log.isTraceEnabled()) {
            this.traceQuery();
        }
        if (!this.isLinkQuery()) {
            throw new ValidationException(Messages.getString("QueryImpl.QueryStringNotValidForMethodWithLinkedWorkItems"));
        }
        _QuerySortOrderEntry[] sort = this.sortFieldList.getLinksSortOrder(this.isTreeQuery());
        if (this.witContext.isVersion2()) {
            throw new NotSupportedException(Messages.getString("QueryImpl.ServerDoesNotSupportLinkQueryType"));
        }
        if (this.witContext.isVersion3()) {
            response = this.witContext.getProxy3().queryWorkitems(psQuery, sort, false, this.witContext.getMetadataUpdateHandler().getHaveEntries(), new DOMAnyContentType(), new StaxAnyContentType());
            metadata = ((_ClientService3Soap_QueryWorkitemsResponse)response).getMetadata();
            dbStamp = ((_ClientService3Soap_QueryWorkitemsResponse)response).getDbStamp();
            resultIds = ((_ClientService3Soap_QueryWorkitemsResponse)response).getResultIds();
            asOfDate = ((_ClientService3Soap_QueryWorkitemsResponse)response).getAsOfDate();
        } else {
            response = this.witContext.getProxy5().queryWorkitems(psQuery, sort, false, this.witContext.getMetadataUpdateHandler().getHaveEntries(), new DOMAnyContentType(), new StaxAnyContentType());
            metadata = ((_ClientService5Soap_QueryWorkitemsResponse)response).getMetadata();
            dbStamp = ((_ClientService5Soap_QueryWorkitemsResponse)response).getDbStamp();
            resultIds = ((_ClientService5Soap_QueryWorkitemsResponse)response).getResultIds();
            asOfDate = ((_ClientService5Soap_QueryWorkitemsResponse)response).getAsOfDate();
        }
        this.witContext.getMetadataUpdateHandler().updateMetadata(metadata, dbStamp);
        metadata.dispose();
        LinkQueryResultParser parser = new LinkQueryResultParser(((DOMAnyContentType)resultIds).getElements()[0]);
        if (this.queryAsOf != null) {
            Calendar resultAsOf = Calendar.getInstance();
            resultAsOf.setTime(this.queryAsOf);
        } else {
            Calendar resultAsOf = asOfDate;
        }
        WorkItemRelation[] links = parser.parse();
        if (log.isDebugEnabled()) {
            int linksLength = links == null ? 0 : links.length;
            log.debug((Object)MessageFormat.format("runLinkQuery returned {0} WorkItemRelation[{1}]", linksLength, linksLength));
        }
        if (this.isTreeQuery()) {
            return this.convertTreeResult(links);
        }
        if (sort.length == 0) {
            log.trace((Object)"<<< Sorting linking query on the client");
            boolean ascending = true;
            if (this.sortFieldList.getSize() == 1) {
                ascending = this.sortFieldList.get(0).getSortType() == SortType.ASCENDING;
            }
            Arrays.sort(links, new WorkItemRelationComparator(ascending));
            log.trace((Object)"<<< Sorting Done");
        }
        return this.convertOneHopResult(links);
    }

    private WorkItemLinkInfo[] convertTreeResult(WorkItemRelation[] relations) {
        if (relations == null) {
            return new WorkItemLinkInfo[0];
        }
        WorkItemLinkInfo[] links = new WorkItemLinkInfo[relations.length];
        for (int i = 0; i < relations.length; ++i) {
            links[i] = new WorkItemLinkInfo(relations[i].getSourceID(), relations[i].getTargetID(), relations[i].getLinkTypeID(), relations[i].isLocked());
        }
        return links;
    }

    private WorkItemLinkInfo[] convertOneHopResult(WorkItemRelation[] relations) {
        int extra = 0;
        int root = 0;
        for (int i = 0; i < relations.length; ++i) {
            if (relations[i].getSourceID() != root && relations[i].getTargetID() != 0) {
                ++extra;
            }
            root = relations[i].getSourceID();
        }
        WorkItemLinkInfo[] links = new WorkItemLinkInfo[relations.length + extra];
        root = 0;
        int index = 0;
        for (int i = 0; i < relations.length; ++i) {
            WorkItemRelation r = relations[i];
            if (r.getSourceID() != root) {
                links[index++] = new WorkItemLinkInfo(0, r.getSourceID(), 0, false);
                root = r.getSourceID();
            }
            if (r.getTargetID() == 0) continue;
            links[index++] = new WorkItemLinkInfo(r.getSourceID(), r.getTargetID(), r.getLinkTypeID(), r.isLocked());
        }
        return links;
    }

    private WorkItemCollection runBatchReadQuery() {
        return new WorkItemCollectionImpl(this.batchIds, this.batchRevs, (Query)this, this.witContext);
    }

    private WorkItemCollection runNormalQuery() {
        Calendar resultAsOf;
        Calendar asOfDate;
        AnyContentType resultIds;
        String dbStamp;
        AnyContentType metadata;
        ElementDeserializable response;
        DOMAnyContentType psQuery = new DOMAnyContentType(new Element[]{this.queryXML});
        if (log.isTraceEnabled()) {
            this.traceQuery();
        }
        if (this.isLinkQuery() || this.isBatchReadMode()) {
            throw new ValidationException(Messages.getString("QueryImpl.QueryStringNotValidForMethodWithFlatWorkItemList"));
        }
        if (this.witContext.isVersion2()) {
            response = this.witContext.getProxy().queryWorkitems(psQuery, this.sortFieldList.getSortOrderEntries(), false, this.witContext.getMetadataUpdateHandler().getHaveEntries(), new DOMAnyContentType(), new StaxAnyContentType());
            metadata = ((_ClientService2Soap_QueryWorkitemsResponse)response).getMetadata();
            dbStamp = ((_ClientService2Soap_QueryWorkitemsResponse)response).getDbStamp();
            resultIds = ((_ClientService2Soap_QueryWorkitemsResponse)response).getResultIds();
            asOfDate = ((_ClientService2Soap_QueryWorkitemsResponse)response).getAsOfDate();
        } else if (this.witContext.isVersion3()) {
            response = this.witContext.getProxy3().queryWorkitems(psQuery, this.sortFieldList.getSortOrderEntries(), false, this.witContext.getMetadataUpdateHandler().getHaveEntries(), new DOMAnyContentType(), new StaxAnyContentType());
            metadata = ((_ClientService3Soap_QueryWorkitemsResponse)response).getMetadata();
            dbStamp = ((_ClientService3Soap_QueryWorkitemsResponse)response).getDbStamp();
            resultIds = ((_ClientService3Soap_QueryWorkitemsResponse)response).getResultIds();
            asOfDate = ((_ClientService3Soap_QueryWorkitemsResponse)response).getAsOfDate();
        } else {
            response = this.witContext.getProxy5().queryWorkitems(psQuery, this.sortFieldList.getSortOrderEntries(), false, this.witContext.getMetadataUpdateHandler().getHaveEntries(), new DOMAnyContentType(), new StaxAnyContentType());
            metadata = ((_ClientService5Soap_QueryWorkitemsResponse)response).getMetadata();
            dbStamp = ((_ClientService5Soap_QueryWorkitemsResponse)response).getDbStamp();
            resultIds = ((_ClientService5Soap_QueryWorkitemsResponse)response).getResultIds();
            asOfDate = ((_ClientService5Soap_QueryWorkitemsResponse)response).getAsOfDate();
        }
        this.witContext.getMetadataUpdateHandler().updateMetadata(metadata, dbStamp);
        metadata.dispose();
        QueryResultParser parser = new QueryResultParser(((DOMAnyContentType)resultIds).getElements()[0]);
        if (this.queryAsOf != null) {
            resultAsOf = Calendar.getInstance();
            resultAsOf.setTime(this.queryAsOf);
        } else {
            resultAsOf = asOfDate;
        }
        int[] ids = parser.parseIDs();
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("queryWorkitems returned {0} id{1}", ids == null ? 0 : ids.length, ids != null && ids.length != 1 ? "s" : ""));
        }
        return new WorkItemCollectionImpl(ids, resultAsOf, (Query)this, this.witContext);
    }

    private void initialize(WITContext witContext, String wiql, Map<String, Object> queryContext, int[] ids, int[] revs, boolean dayPrecision) {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("using WIQL: [{0}]", wiql));
        }
        Check.notNull(witContext, "witContext");
        Check.notNull(wiql, "wiql");
        if (ids != null) {
            if (revs != null && ids.length != revs.length) {
                throw new IllegalArgumentException(MessageFormat.format("Should be equal numbers of Ids and Revs passed. ids=int[{0}], revs=[{1}]", ids.length, revs.length));
            }
            HashSet<Integer> idSet = new HashSet<Integer>(ids.length);
            for (int i = 0; i < ids.length; ++i) {
                if (idSet.contains(new Integer(ids[i]))) {
                    throw new DuplicateBatchReadParameterException();
                }
                idSet.add(new Integer(ids[i]));
            }
        }
        this.witContext = witContext;
        try {
            WIQLAdapter wiqlAdapter = new WIQLAdapter(witContext);
            wiqlAdapter.setContext(queryContext);
            wiqlAdapter.setDayPrecision(dayPrecision);
            this.wiqlNode = Parser.parseSyntax(wiql);
            this.wiqlNode.bind(wiqlAdapter, null, null);
            boolean serverSupportsWIQLEvaluation = witContext.getServerInfo().isSupported("WiqlEvaluationOnServer");
            if (!serverSupportsWIQLEvaluation) {
                this.wiqlNode = (NodeSelect)this.wiqlNode.optimize(wiqlAdapter, null, null);
            }
            if (ids != null) {
                if (this.wiqlNode.getWhere() != null || this.wiqlNode.getOrderBy() != null) {
                    throw new ValidationException(Messages.getString("QueryImpl.WhereAndOrderByClausesNotSupportedOnParameterizedQuery"));
                }
                if (this.isLinkQuery()) {
                    throw new ValidationException(Messages.getString("QueryImpl.FromClauseCannotSpecifyLinksOnParameterizedQuery"));
                }
                this.batchIds = ids;
                this.batchRevs = revs;
            } else if (serverSupportsWIQLEvaluation) {
                this.queryXML = wiqlAdapter.getQueryXML(wiql, queryContext, this.isLinkQuery(), dayPrecision);
            } else if (this.isLinkQuery()) {
                LinkQueryXMLResult result = wiqlAdapter.getLinkQueryXML(this.wiqlNode);
                this.queryXML = result.getLinkXML();
                this.linkGroup = result.getLinkGroup();
            } else {
                this.queryXML = wiqlAdapter.getQueryXML(this.wiqlNode);
            }
            this.queryAsOf = wiqlAdapter.getAsOfUTC(this.wiqlNode);
            this.displayFieldList = (DisplayFieldListImpl)wiqlAdapter.getDisplayFieldList(witContext, this.wiqlNode);
            this.sortFieldList = (SortFieldListImpl)wiqlAdapter.getSortFieldList(witContext, this.wiqlNode);
        }
        catch (SyntaxException ex) {
            throw new InvalidQueryTextException(ex.getDetails(), wiql, ex);
        }
    }

    public WorkItemLinkTypeEnd[] getLinkTypes() {
        if (!this.isLinkQuery()) {
            return null;
        }
        if (this.linkGroup != null) {
            WIQLAdapter wiqlAdapter = new WIQLAdapter(this.witContext);
            Map<Integer, Boolean> map = wiqlAdapter.computeLinkTypes(this.linkGroup);
            WorkItemLinkTypeEnd[] types = new WorkItemLinkTypeEnd[map.size()];
            int index = 0;
            for (int id : map.keySet()) {
                types[index++] = this.witContext.getClient().getLinkTypes().getLinkTypeEnds().getByID(id);
            }
            return types;
        }
        WorkItemLinkTypeEndCollection linkTypes = this.witContext.getClient().getLinkTypes().getLinkTypeEnds();
        return linkTypes.toArray(new WorkItemLinkTypeEnd[linkTypes.getCount()]);
    }

    private void traceQuery() {
        StringBuffer sb = new StringBuffer();
        sb.append("running query:").append(NEWLINE);
        sb.append(DOMSerializeUtils.toString(this.queryXML)).append(NEWLINE);
        sb.append("sort: ");
        _QuerySortOrderEntry[] sortOrderEntries = this.sortFieldList.getSortOrderEntries();
        for (int i = 0; i < sortOrderEntries.length; ++i) {
            sb.append(sortOrderEntries[i].getColumnName()).append(" ");
            sb.append(sortOrderEntries[i].isAscending() ? "ASC" : "DESC");
            if (i >= sortOrderEntries.length - 1) continue;
            sb.append(" ");
        }
        sb.append(NEWLINE);
        String mode = "flat";
        if (this.isLinkQuery()) {
            mode = this.isTreeQuery() ? "tree" : "one-hop";
        }
        sb.append("mode:" + mode);
        log.trace((Object)sb.toString());
    }

    private int[] copyArray(int[] toCopy) {
        if (toCopy == null) {
            return null;
        }
        int[] retArray = new int[toCopy.length];
        System.arraycopy(toCopy, 0, retArray, 0, toCopy.length);
        return retArray;
    }

    @Override
    public WorkItemClient getWorkItemClient() {
        return this.witContext.getClient();
    }
}

