/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.query.qe;

import com.microsoft.tfs.core.clients.workitem.internal.query.qe.QEQueryConnectionImp;
import com.microsoft.tfs.core.clients.workitem.internal.query.qe.QEQueryImpl;
import com.microsoft.tfs.core.clients.workitem.query.qe.QEQueryConnection;
import com.microsoft.tfs.core.clients.workitem.query.qe.QEQueryConnectionType;
import com.microsoft.tfs.core.clients.workitem.query.qe.QEQueryGrouping;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class QEQueryGroupingImp
implements QEQueryGrouping {
    private final QEQueryImpl query;
    private final List<GroupNode> list = new ArrayList<GroupNode>();

    public QEQueryGroupingImp(QEQueryImpl query) {
        this.query = query;
    }

    @Override
    public void addGrouping(int row1, int row2) {
        if (row1 >= row2 || row1 < 0) {
            throw new IllegalArgumentException(MessageFormat.format("the args row1={0} and row2={1} are invalid", Integer.toString(row1), Integer.toString(row2)));
        }
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.getItem(i).getRow1() == row1 && this.getItem(i).getRow2() == row2) {
                return;
            }
            if (this.getItem(i).getRow2() == row1) {
                throw new RuntimeException("cannot group");
            }
            if (this.getItem(i).getRow1() == row2) {
                throw new RuntimeException("cannot group");
            }
            if ((this.getItem(i).getRow1() >= row1 || this.getItem(i).getRow2() <= row1 || this.getItem(i).getRow2() >= row2) && (this.getItem(i).getRow1() >= row2 || this.getItem(i).getRow2() <= row2 || this.getItem(i).getRow1() <= row1)) continue;
            throw new RuntimeException("cannot group");
        }
        GroupNode node1 = new GroupNode(row1, row2);
        this.list.add(node1);
        this.query.notifyModifiedListeners();
    }

    @Override
    public boolean canGroup(int row1, int row2) {
        if (row1 >= row2 || row1 < 0) {
            return false;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.getItem(i).getRow1() == row1 && this.getItem(i).getRow2() == row2) {
                return false;
            }
            if (this.getItem(i).getRow2() == row1) {
                return false;
            }
            if (this.getItem(i).getRow1() == row2) {
                return false;
            }
            if ((this.getItem(i).getRow1() >= row1 || this.getItem(i).getRow2() <= row1 || this.getItem(i).getRow2() >= row2) && (this.getItem(i).getRow1() >= row2 || this.getItem(i).getRow2() <= row2 || this.getItem(i).getRow1() <= row1)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canUngroup(int row1, int row2) {
        if (row1 < row2 && row1 >= 0) {
            for (int i = 0; i < this.list.size(); ++i) {
                if (this.getItem(i).getRow1() != row1 || this.getItem(i).getRow2() != row2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public QEQueryConnection getConnection(int depth, int row) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.depth(this.getItem(i)) != depth) continue;
            if (this.getItem(i).getRow1() == row) {
                return new QEQueryConnectionImp(QEQueryConnectionType.DOWN, row, this.getItem(i).getRow2());
            }
            if (this.getItem(i).getRow2() == row) {
                return new QEQueryConnectionImp(QEQueryConnectionType.UP, this.getItem(i).getRow1(), row);
            }
            if (this.getItem(i).getRow1() >= row || this.getItem(i).getRow2() <= row) continue;
            return new QEQueryConnectionImp(QEQueryConnectionType.ACROSS);
        }
        return new QEQueryConnectionImp(QEQueryConnectionType.NONE);
    }

    @Override
    public boolean hasGroup(int row1, int row2) {
        return this.canUngroup(row1, row2);
    }

    @Override
    public boolean hasGroupings() {
        return this.list.size() > 0;
    }

    @Override
    public int getMaxDepth() {
        int num1 = 0;
        for (int i = 0; i < this.list.size(); ++i) {
            int num3 = this.depth(this.getItem(i));
            if (num1 >= num3) continue;
            num1 = num3;
        }
        return num1;
    }

    @Override
    public boolean removeGrouping(int row1, int row2) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.getItem(i).getRow1() != row1 || this.getItem(i).getRow2() != row2) continue;
            this.list.remove(i);
            this.query.notifyModifiedListeners();
            return true;
        }
        return false;
    }

    @Override
    public boolean rowInGroup(int row) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.getItem(i).getRow1() != row && this.getItem(i).getRow2() != row) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rowIsGrouped(int row) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.getItem(i).getRow1() > row || this.getItem(i).getRow2() < row) continue;
            return true;
        }
        return false;
    }

    private GroupNode getItem(int index) {
        return this.list.get(index);
    }

    public void addRow(int row) {
        if (row < 0) {
            throw new IllegalArgumentException("row is out of range");
        }
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.getItem(i).getRow1() >= row) {
                this.getItem(i).setRow1(this.getItem(i).getRow1() + 1);
            }
            if (this.getItem(i).getRow2() < row) continue;
            this.getItem(i).setRow2(this.getItem(i).getRow2() + 1);
        }
    }

    public void clear() {
        this.list.clear();
        this.query.notifyModifiedListeners();
    }

    private int depth(GroupNode node) {
        return this.nestedGroupCount(node) + 1;
    }

    private boolean isDuplicate(GroupNode node) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (node == this.getItem(i) || this.getItem(i).getRow1() != node.getRow1() || this.getItem(i).getRow2() != node.getRow2()) continue;
            return true;
        }
        return false;
    }

    private boolean isNested(GroupNode parent, GroupNode node) {
        if (parent.getRow1() <= node.getRow1()) {
            return parent.getRow2() >= node.getRow2();
        }
        return false;
    }

    private int nestedGroupCount(GroupNode parent) {
        int num1 = 0;
        for (int i = 0; i < this.list.size(); ++i) {
            if (parent == this.getItem(i) || !this.isNested(parent, this.getItem(i))) continue;
            ++num1;
        }
        return num1;
    }

    public void removeRow(int row) {
        if (row < 0) {
            throw new IllegalArgumentException("row is out of range");
        }
        int num1 = 0;
        while (num1 < this.list.size()) {
            GroupNode node1 = this.getItem(num1);
            if (node1.getRow1() == row) {
                if (node1.getRow2() == row + 1) {
                    this.list.remove(num1);
                } else {
                    node1.setRow2(node1.getRow2() - 1);
                }
            } else if (node1.getRow2() == row) {
                if (node1.getRow1() == row - 1) {
                    this.list.remove(num1);
                } else {
                    node1.setRow2(row - 1);
                }
            } else {
                if (node1.getRow1() > row) {
                    node1.setRow1(node1.getRow1() - 1);
                }
                if (node1.getRow2() > row) {
                    node1.setRow2(node1.getRow2() - 1);
                }
            }
            if (num1 >= this.list.size() || node1 != this.getItem(num1)) continue;
            ++num1;
        }
        int num2 = 0;
        while (num2 < this.list.size()) {
            if (this.isDuplicate(this.getItem(num2))) {
                this.list.remove(num2);
                continue;
            }
            ++num2;
        }
    }

    private static class GroupNode {
        private int row1;
        private int row2;

        public GroupNode(int row1, int row2) {
            this.row1 = row1;
            this.row2 = row2;
        }

        public int getRow1() {
            return this.row1;
        }

        public void setRow1(int row1) {
            this.row1 = row1;
        }

        public int getRow2() {
            return this.row2;
        }

        public void setRow2(int row2) {
            this.row2 = row2;
        }
    }
}

