/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.queryhierarchy;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.webservices.IdentityDescriptor;
import com.microsoft.tfs.core.clients.workitem.exceptions.WorkItemException;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.query.StoredQueryImpl;
import com.microsoft.tfs.core.clients.workitem.internal.queryhierarchy.QueryDefinitionUtil;
import com.microsoft.tfs.core.clients.workitem.internal.queryhierarchy.QueryFolderAction;
import com.microsoft.tfs.core.clients.workitem.internal.queryhierarchy.QueryFolderImpl;
import com.microsoft.tfs.core.clients.workitem.internal.queryhierarchy.QueryItemImpl;
import com.microsoft.tfs.core.clients.workitem.query.InvalidQueryTextException;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryDefinition;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryFolder;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryItemType;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryType;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;

public class QueryDefinitionImpl
extends QueryItemImpl
implements QueryDefinition {
    private String queryText;
    private String originalQueryText;
    private QueryType type;

    public QueryDefinitionImpl(String name, String queryText) {
        this(name, queryText, null);
    }

    public QueryDefinitionImpl(String name, String queryText, QueryFolder parent) {
        super(name, parent);
        try {
            this.originalQueryText = queryText;
            this.setQueryTextWithValidation(queryText);
        }
        catch (RuntimeException e) {
            if (parent != null && parent.contains(this)) {
                this.delete();
            }
            throw e;
        }
    }

    QueryDefinitionImpl(String name, String queryText, QueryFolder parent, GUID id, IdentityDescriptor ownerDescriptor) {
        super(name, parent, id, ownerDescriptor);
        this.setQueryTextInternal(queryText);
        this.originalQueryText = queryText;
    }

    @Override
    protected void resetDirty() {
        this.originalQueryText = this.queryText;
        super.resetDirty();
    }

    @Override
    protected void resetInternal() {
        this.setQueryTextInternal(this.originalQueryText);
        super.resetInternal();
    }

    protected void setQueryTextProtected(String queryText) {
        this.setQueryTextInternal(queryText);
        this.originalQueryText = queryText;
    }

    private void setQueryTextInternal(String queryText) {
        this.queryText = queryText;
        this.type = null;
    }

    private void setQueryTextWithValidation(String queryText) throws WorkItemException, InvalidQueryTextException {
        Check.notNull(queryText, "queryText");
        if (this.isDeleted()) {
            throw new WorkItemException(Messages.getString("QueryDefinition.CannotModifyDeletedItem"));
        }
        if (queryText.trim().length() == 0) {
            throw new IllegalArgumentException(Messages.getString("QueryDefinition.QueryTextCannotBeEmpty"));
        }
        StoredQueryImpl.validateWIQL(this.getProject().getWITContext(), queryText);
        this.setQueryTextInternal(queryText);
    }

    @Override
    protected void validate(WITContext context) {
        if (this.isDirty()) {
            StoredQueryImpl.validateWIQL(context, this.getQueryText());
        }
    }

    @Override
    protected boolean isDirtyShallow() {
        if (!super.isDirtyShallow()) {
            return !this.queryText.equals(this.originalQueryText);
        }
        return true;
    }

    @Override
    public String getOriginalQueryText() {
        return this.originalQueryText;
    }

    @Override
    public String getQueryText() {
        return this.queryText;
    }

    @Override
    public void setQueryText(String queryText) throws InvalidQueryTextException {
        this.setQueryTextWithValidation(queryText);
        if (this.getParent() != null && this.getParent() instanceof QueryFolderImpl) {
            ((QueryFolderImpl)this.getParent()).onContentsChanged(this, QueryFolderAction.CHANGED);
        }
    }

    @Override
    public QueryType getQueryType() {
        if (this.type == null) {
            this.type = QueryDefinitionUtil.getQueryType(this.queryText);
        }
        return this.type;
    }

    @Override
    protected void onSaveCompleted() {
        this.originalQueryText = this.queryText;
        super.onSaveCompleted();
    }

    @Override
    public QueryItemType getType() {
        return QueryItemType.QUERY_DEFINITION;
    }
}

