/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.type;

import com.microsoft.tfs.core.clients.workitem.internal.type.WITypeConverter;
import com.microsoft.tfs.core.clients.workitem.internal.type.WITypeConverterException;
import com.microsoft.tfs.core.clients.workitem.internal.type.WIValueSource;
import com.microsoft.tfs.util.GUID;
import java.text.MessageFormat;

public class WIGUIDTypeConverter
implements WITypeConverter {
    @Override
    public Object translate(Object input, WIValueSource valueSource) throws WITypeConverterException {
        if (input == null) {
            return null;
        }
        if (input instanceof GUID) {
            return input;
        }
        if (input instanceof String) {
            String valueToParse = ((String)input).trim();
            try {
                return new GUID(valueToParse);
            }
            catch (IllegalArgumentException e) {
                throw new WITypeConverterException(MessageFormat.format("unable to convert value [{0}] to a GUID (SERVER value)", valueToParse), e);
            }
        }
        throw new WITypeConverterException(MessageFormat.format("unable to convert value [{0}] to a GUID (SERVER value)", input.getClass().getName()));
    }

    @Override
    public String toString(Object data) {
        if (data == null) {
            return null;
        }
        return data.toString();
    }
}

