/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.update;

import com.microsoft.tfs.core.clients.workitem.fields.FieldType;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.WorkItemImpl;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldImpl;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldModificationType;
import com.microsoft.tfs.core.clients.workitem.internal.fields.ServerComputedFieldType;
import com.microsoft.tfs.core.clients.workitem.internal.update.BaseUpdatePackage;
import com.microsoft.tfs.core.clients.workitem.internal.update.ElementHandler;
import com.microsoft.tfs.core.ws.runtime.types.DOMAnyContentType;
import com.microsoft.tfs.util.xml.DOMSerializeUtils;
import com.microsoft.tfs.util.xml.DOMUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WorkItemUpdatePackage
extends BaseUpdatePackage {
    private final WorkItemImpl workItem;
    private final Element workItemElement;
    private Element columnsElement;
    private Element computedColumnsElement;
    private final Map<String, List<ElementHandler>> updateElementNamesToHandlerLists = new HashMap<String, List<ElementHandler>>();

    public WorkItemUpdatePackage(WorkItemImpl workItem, WITContext context) {
        super(context);
        this.workItem = workItem;
        this.workItemElement = this.createWorkItemElement();
        this.processFields();
        this.addHardcodedComputedColumns();
        this.processLinks();
        this.processAttachments();
        if (context.isVersion3OrHigher() && this.workItemElement.getChildNodes().getLength() == 1) {
            this.getRoot().removeChild(this.workItemElement);
        }
    }

    private Element createWorkItemElement() {
        Element element;
        if (this.workItem.getFields().getID() == 0) {
            element = DOMUtils.appendChild(this.getRoot(), "InsertWorkItem");
            element.setAttribute("TempID", String.valueOf(-this.workItem.getTemporaryID()));
        } else {
            element = DOMUtils.appendChild(this.getRoot(), "UpdateWorkItem");
            element.setAttribute("WorkItemID", String.valueOf(this.workItem.getFields().getID()));
            element.setAttribute("Revision", String.valueOf(this.workItem.getFields().getField("System.Rev").getOriginalValue()));
        }
        element.setAttribute("ObjectType", "WorkItem");
        return element;
    }

    private void processFields() {
        for (FieldImpl field : this.workItem.getFields()) {
            if (field.isComputed() || !field.isDirty()) continue;
            if (field.getFieldDefinitionInternal().isLargeText()) {
                this.processLargeTextField(field);
                continue;
            }
            this.processNonLargeTextField(field);
        }
    }

    private void processLargeTextField(FieldImpl field) {
        String value = field.getNewValueAsString();
        Element insertText = value != null ? DOMUtils.appendChildWithText(this.workItemElement, "InsertText", value) : DOMUtils.appendChild(this.workItemElement, "InsertText");
        insertText.setAttribute("FieldName", field.getReferenceName());
        insertText.setAttribute("FieldDisplayName", field.getName());
    }

    private void processNonLargeTextField(FieldImpl field) {
        if (this.columnsElement == null) {
            this.columnsElement = DOMUtils.appendChild(this.workItemElement, "Columns");
        }
        if (field.getServerComputedType() != null) {
            Element c = DOMUtils.appendChild(this.columnsElement, "Column");
            c.setAttribute("Column", field.getReferenceName());
            ServerComputedFieldType type = field.getServerComputedType();
            if (type == ServerComputedFieldType.DATE_TIME || type == ServerComputedFieldType.RANDOM_GUID) {
                c.setAttribute("Type", field.getServerComputedType().getName());
            } else {
                DOMUtils.appendChildWithText(c, "Value", this.getContext().getCurrentUserDisplayName());
            }
            if (this.computedColumnsElement == null) {
                this.computedColumnsElement = DOMUtils.appendChild(this.workItemElement, "ComputedColumns");
            }
            DOMUtils.appendChild(this.computedColumnsElement, "ComputedColumn").setAttribute("Column", field.getReferenceName());
        } else {
            String value = field.getNewValueAsString();
            Element c = DOMUtils.appendChild(this.columnsElement, "Column");
            c.setAttribute("Column", field.getReferenceName());
            FieldType type = field.getFieldDefinitionInternal().getFieldType();
            if (type == FieldType.STRING) {
                c.setAttribute("Type", "String");
            } else if (type == FieldType.INTEGER) {
                c.setAttribute("Type", "Number");
            } else if (type == FieldType.DATETIME) {
                c.setAttribute("Type", "DateTime");
            } else if (type == FieldType.DOUBLE) {
                c.setAttribute("Type", "Double");
            } else if (type == FieldType.GUID) {
                c.setAttribute("Type", "Guid");
            }
            if (value != null) {
                DOMUtils.appendChildWithText(c, "Value", value);
            } else {
                DOMUtils.appendChild(c, "Value");
            }
        }
    }

    private void addHardcodedComputedColumns() {
        if (this.computedColumnsElement == null) {
            this.computedColumnsElement = DOMUtils.appendChild(this.workItemElement, "ComputedColumns");
        }
        DOMUtils.appendChild(this.computedColumnsElement, "ComputedColumn").setAttribute("Column", "System.RevisedDate");
        DOMUtils.appendChild(this.computedColumnsElement, "ComputedColumn").setAttribute("Column", "System.ChangedDate");
        DOMUtils.appendChild(this.computedColumnsElement, "ComputedColumn").setAttribute("Column", "System.PersonId");
        if (this.workItem.getClient().getFieldDefinitions().contains("System.AuthorizedDate")) {
            DOMUtils.appendChild(this.computedColumnsElement, "ComputedColumn").setAttribute("Column", "System.AuthorizedDate");
        }
    }

    private void processLinks() {
        this.addElementHandlers(this.workItem.getLinksInternal().addUpdateXML(this.workItemElement));
    }

    private void processAttachments() {
        this.addElementHandlers(this.workItem.getAttachmentsInternal().addUpdateXML(this.workItemElement));
    }

    private void addElementHandlers(ElementHandler[] handlers) {
        if (handlers == null) {
            return;
        }
        for (int i = 0; i < handlers.length; ++i) {
            List<ElementHandler> handlerList = this.updateElementNamesToHandlerLists.get(handlers[i].getElementName());
            if (handlerList == null) {
                handlerList = new ArrayList<ElementHandler>();
                this.updateElementNamesToHandlerLists.put(handlers[i].getElementName(), handlerList);
            }
            handlerList.add(handlers[i]);
        }
    }

    @Override
    protected void handleUpdateResponse(DOMAnyContentType response) {
        Element computedColumnsElement;
        Element responseElement;
        Element updateResultsElement = response.getElements()[0];
        if (this.workItem.getFields().getID() == 0) {
            responseElement = (Element)updateResultsElement.getElementsByTagName("InsertWorkItem").item(0);
            if (responseElement == null) {
                try {
                    throw new RuntimeException(MessageFormat.format("expected an InsertWorkItem element in [{0}]", DOMSerializeUtils.toString(updateResultsElement)));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            responseElement = (Element)updateResultsElement.getElementsByTagName("UpdateWorkItem").item(0);
            if (responseElement == null) {
                return;
            }
        }
        String newRevision = responseElement.getAttribute("Revision");
        this.workItem.getFieldsInternal().getFieldInternal(8).setValue((Object)newRevision, FieldModificationType.SERVER);
        if (this.workItem.getFields().getID() == 0) {
            String newId = responseElement.getAttribute("ID");
            this.workItem.getFieldsInternal().getFieldInternal(-3).setValue((Object)newId, FieldModificationType.SERVER);
        }
        if ((computedColumnsElement = (Element)updateResultsElement.getElementsByTagName("ComputedColumns").item(0)) != null) {
            NodeList computedColumns = computedColumnsElement.getElementsByTagName("ComputedColumn");
            for (int i = 0; i < computedColumns.getLength(); ++i) {
                Element computedColumnElement = (Element)computedColumns.item(i);
                String fieldReferenceName = computedColumnElement.getAttribute("Column");
                String value = computedColumnElement.getElementsByTagName("Value").item(0).getChildNodes().item(0).getNodeValue();
                FieldImpl field = this.workItem.getFieldsInternal().getFieldInternal(fieldReferenceName);
                field.setValue((Object)value, FieldModificationType.SERVER);
            }
        }
        for (String elementName : this.updateElementNamesToHandlerLists.keySet()) {
            List<ElementHandler> handlerList = this.updateElementNamesToHandlerLists.get(elementName);
            NodeList elements = updateResultsElement.getElementsByTagName(elementName);
            for (int i = 0; i < elements.getLength(); ++i) {
                Element element = (Element)elements.item(i);
                ElementHandler handler = handlerList.get(i);
                handler.handle(element);
            }
        }
    }
}

