/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.wiqlparse;

import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Arithmetic;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.ArithmeticalOperators;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Condition;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.ConditionalOperators;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Direction;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Node;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeAndOperator;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeArithmetic;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeCondition;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeEverOperator;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeFieldList;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeFieldName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeItem;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeMode;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeNotOperator;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeOrOperator;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeSelect;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeTableName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeValueList;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.SyntaxError;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.SyntaxException;
import java.util.List;
import java.util.Stack;

public class Scanner {
    private final List<Node> tokens;
    private int currentPosition = 0;

    public Scanner(List<Node> tokens) {
        this.tokens = tokens;
    }

    public NodeSelect scan() {
        return this.scanSelect();
    }

    public void checkTail() {
        int num1 = this.currentPosition;
        NodeItem item1 = this.nextToken();
        if (item1 != null && (item1.getNodeType() != NodeType.OPERATION || item1.getValue().length() != 0)) {
            this.currentPosition = num1;
            this.throwSyntaxError(SyntaxError.EXPECTING_END_OF_STRING);
        }
    }

    private NodeSelect scanSelect() {
        NodeItem node1 = this.ensureToken(NodeType.NAME, "select", SyntaxError.EXPECTING_SELECT);
        NodeSelect select1 = new NodeSelect();
        if (this.scanToken(NodeType.OPERATION, "*") != null) {
            select1.setFields(null);
        } else {
            select1.setFields(this.scanFieldNameList(false, NodeType.FIELD_LIST));
        }
        while (true) {
            if (this.scanToken(NodeType.NAME, "from") != null) {
                if (select1.getFrom() != null) {
                    --this.currentPosition;
                    this.throwSyntaxError(SyntaxError.DUPLICATE_FROM);
                }
                select1.setFrom(this.scanTableName());
                continue;
            }
            if (this.scanToken(NodeType.NAME, "where") != null) {
                if (select1.getWhere() != null) {
                    --this.currentPosition;
                    this.throwSyntaxError(SyntaxError.DUPLICATE_WHERE);
                }
                select1.setWhere(this.scanWhere(select1.getFrom()));
                continue;
            }
            if (this.scanToken(NodeType.NAME, "group") != null) {
                this.ensureToken(NodeType.NAME, "by", SyntaxError.EXPECTING_BY);
                if (select1.getGroupBy() != null) {
                    --this.currentPosition;
                    this.throwSyntaxError(SyntaxError.DUPLICATE_GROUP_BY);
                }
                select1.setGroupBy(this.scanFieldNameList(false, NodeType.GROUP_FIELD_LIST));
                continue;
            }
            if (this.scanToken(NodeType.NAME, "order") != null) {
                this.ensureToken(NodeType.NAME, "by", SyntaxError.EXPECTING_BY);
                if (select1.getOrderBy() != null) {
                    --this.currentPosition;
                    this.throwSyntaxError(SyntaxError.DUPLICATE_ORDER_BY);
                }
                select1.setOrderBy(this.scanFieldNameList(true, NodeType.ORDER_FIELD_LIST));
                continue;
            }
            if (this.scanToken(NodeType.NAME, "asof") != null) {
                if (select1.getAsOf() != null) {
                    --this.currentPosition;
                    this.throwSyntaxError(SyntaxError.DUPLICATE_AS_OF);
                }
                select1.setAsOf(this.scanValue(select1.getFrom()));
                continue;
            }
            if (this.scanToken(NodeType.NAME, "mode") == null) break;
            if (select1.getMode() != null) {
                --this.currentPosition;
                this.throwSyntaxError(SyntaxError.DUPLICATE_MODE);
            }
            select1.setMode(this.ScanMode());
        }
        select1.setStartOffset(node1.getStartOffset());
        select1.setEndOffset(((NodeItem)this.tokens.get(this.tokens.size() - 1)).getEndOffset());
        return select1;
    }

    private Node scanWhere(NodeTableName table) {
        return this.scanCondition4(table);
    }

    private Node scanCondition4(NodeTableName table) {
        Node node1 = this.scanCondition3(table);
        NodeOrOperator operator1 = null;
        while (true) {
            NodeItem node2;
            if ((node2 = this.scanToken(NodeType.NAME, "or")) == null) {
                node2 = this.scanToken(NodeType.OPERATION, "||");
            }
            if (node2 == null) break;
            if (operator1 == null) {
                operator1 = new NodeOrOperator();
                operator1.add(node1);
            }
            operator1.add(this.scanCondition3(table));
        }
        if (operator1 != null) {
            operator1.setStartOffset(operator1.getItem(0).getStartOffset());
            operator1.setEndOffset(operator1.getItem(operator1.getCount() - 1).getEndOffset());
            node1 = operator1;
        }
        return node1;
    }

    private Node scanCondition3(NodeTableName table) {
        Node node1 = this.scanCondition2(table);
        NodeAndOperator operator1 = null;
        while (true) {
            NodeItem node2;
            if ((node2 = this.scanToken(NodeType.NAME, "and")) == null) {
                node2 = this.scanToken(NodeType.OPERATION, "&&");
            }
            if (node2 == null) break;
            if (operator1 == null) {
                operator1 = new NodeAndOperator();
                operator1.add(node1);
            }
            operator1.add(this.scanCondition2(table));
        }
        if (operator1 != null) {
            operator1.setStartOffset(operator1.getItem(0).getStartOffset());
            operator1.setEndOffset(operator1.getItem(operator1.getCount() - 1).getEndOffset());
            node1 = operator1;
        }
        return node1;
    }

    private Node scanCondition2(NodeTableName table) {
        NodeItem node1 = this.scanToken(NodeType.NAME, "not");
        if (node1 == null) {
            node1 = this.scanToken(NodeType.OPERATION, "!");
        }
        if (node1 != null) {
            Node node2 = this.scanCondition2(table);
            NodeNotOperator node3 = new NodeNotOperator(node2);
            node3.setStartOffset(node1.getStartOffset());
            node3.setEndOffset(node2.getEndOffset());
            return node3;
        }
        node1 = this.scanToken(NodeType.NAME, "ever");
        if (node1 != null) {
            Node node4 = this.scanCondition2(table);
            NodeEverOperator node5 = new NodeEverOperator(node4);
            node5.setStartOffset(node1.getStartOffset());
            node5.setEndOffset(node4.getEndOffset());
            return node5;
        }
        node1 = this.scanToken(NodeType.NAME, "never");
        if (node1 != null) {
            Node node6 = this.scanCondition2(table);
            NodeNotOperator node7 = new NodeNotOperator(new NodeEverOperator(node6));
            node7.setStartOffset(node1.getStartOffset());
            node7.setEndOffset(node6.getEndOffset());
            return node7;
        }
        return this.scanCondition1(table);
    }

    private Node scanCondition1(NodeTableName table) {
        NodeItem node1 = this.scanToken(NodeType.OPERATION, "(");
        if (node1 != null) {
            Node node2 = this.scanWhere(table);
            NodeItem node3 = this.ensureToken(NodeType.OPERATION, ")", SyntaxError.EXPECTING_LEFT_BRACKET);
            node2.setStartOffset(node1.getStartOffset());
            node2.setEndOffset(node3.getEndOffset());
            node2.setHasParantheses(true);
            return node2;
        }
        NodeCondition condition1 = new NodeCondition();
        Node node4 = condition1;
        condition1.setLeft(this.scanFieldName(table));
        Stack<NodeType> stack1 = new Stack<NodeType>();
        while (true) {
            if (this.scanToken(NodeType.NAME, "not") != null) {
                stack1.push(NodeType.NOT);
                continue;
            }
            if (this.scanToken(NodeType.NAME, "ever") != null) {
                stack1.push(NodeType.EVER);
                continue;
            }
            if (this.scanToken(NodeType.NAME, "never") == null) break;
            stack1.push(NodeType.NOT);
            stack1.push(NodeType.EVER);
        }
        while (true) {
            if (stack1.size() <= 0) {
                condition1.setCondition(this.scanConditionOperator(node4 != condition1));
                if (condition1.getCondition() == Condition.NONE) {
                    this.throwSyntaxError(SyntaxError.EXPECTING_COMPARISON_OPERATOR);
                }
                if (condition1.getCondition() == Condition.GROUP) {
                    condition1.setRight(this.scanValue(table));
                } else if (condition1.getCondition() == Condition.IN) {
                    NodeItem node5 = this.ensureToken(NodeType.OPERATION, "(", SyntaxError.EXPECTING_LEFT_BRACKET);
                    Node node6 = this.scanValueList(table);
                    NodeItem node7 = this.ensureToken(NodeType.OPERATION, ")", SyntaxError.EXPECTING_RIGHT_BRACKET);
                    node6.setStartOffset(node5.getStartOffset());
                    node6.setEndOffset(node7.getEndOffset());
                    condition1.setRight(node6);
                } else if (condition1.getCondition() == Condition.UNDER) {
                    condition1.setRight(this.scanValue(table));
                } else {
                    Node node8 = this.TryScanFieldName();
                    if (node8 == null) {
                        node8 = this.TryScanExpression();
                    }
                    if (node8 != null) {
                        condition1.setRight(node8);
                    } else {
                        this.throwSyntaxError(SyntaxError.EXPECTING_FIELD_OR_EXPRESSION);
                    }
                }
                node4.setStartOffset(condition1.getLeft().getStartOffset());
                node4.setEndOffset(condition1.getRight().getEndOffset());
                return node4;
            }
            NodeType nodeType = (NodeType)stack1.pop();
            if (nodeType == NodeType.NOT) {
                node4 = new NodeNotOperator(node4);
                continue;
            }
            if (nodeType != NodeType.EVER) continue;
            node4 = new NodeEverOperator(node4);
        }
    }

    private Node scanValueList(NodeTableName table) {
        NodeValueList list1 = new NodeValueList();
        do {
            list1.add(this.scanExpression(table));
        } while (this.scanToken(NodeType.OPERATION, ",") != null);
        list1.setStartOffset(list1.getItem(0).getStartOffset());
        list1.setEndOffset(list1.getItem(list1.getCount() - 1).getEndOffset());
        return list1;
    }

    private Node scanValue(NodeTableName table) {
        Node node = this.TryScanSingleValue();
        if (node == null) {
            this.throwSyntaxError(SyntaxError.EXPECTING_VALUE);
        }
        return node;
    }

    private Node scanExpression(NodeTableName nodeTable) {
        Node node = this.TryScanExpression();
        if (node == null) {
            this.throwSyntaxError(SyntaxError.EXPECTING_VALUE);
            return null;
        }
        return node;
    }

    private Condition scanConditionOperator(boolean afterNotOrEver) {
        int num1 = this.currentPosition;
        NodeItem item1 = this.nextToken();
        if (item1 != null && (item1.getNodeType() == NodeType.NAME || item1.getNodeType() == NodeType.OPERATION && !afterNotOrEver)) {
            Condition condition1 = ConditionalOperators.find(item1.getValue());
            if (condition1 == Condition.IN && this.scanToken(NodeType.NAME, "group") != null) {
                condition1 = Condition.GROUP;
            } else if (condition1 == Condition.CONTAINS && this.scanToken(NodeType.NAME, "words") != null) {
                condition1 = Condition.CONTAINS_WORDS;
            }
            if (condition1 != Condition.NONE) {
                return condition1;
            }
        }
        this.currentPosition = num1;
        if (!afterNotOrEver) {
            return Condition.NONE;
        }
        return Condition.EQUALS;
    }

    private NodeTableName scanTableName() {
        int savedCurrentPosition = this.currentPosition;
        NodeItem tokenNode = this.nextToken();
        if (tokenNode != null && tokenNode.getNodeType() == NodeType.NAME) {
            return new NodeTableName((NodeName)tokenNode);
        }
        this.currentPosition = savedCurrentPosition;
        this.throwSyntaxError(SyntaxError.EXPECTING_TABLE_NAME);
        return null;
    }

    private NodeFieldList scanFieldNameList(boolean direction, NodeType nodeType) {
        NodeFieldList fieldListNode = new NodeFieldList(nodeType);
        do {
            NodeFieldName fieldNameNode = this.scanFieldName(null);
            if (direction) {
                if (this.scanToken(NodeType.NAME, "asc") != null) {
                    fieldNameNode.setDirection(Direction.ASCENDING);
                } else if (this.scanToken(NodeType.NAME, "desc") != null) {
                    fieldNameNode.setDirection(Direction.DESCENDING);
                }
            }
            fieldListNode.add(fieldNameNode);
        } while (this.scanToken(NodeType.OPERATION, ",") != null);
        if (fieldListNode.getCount() != 0) {
            fieldListNode.setStartOffset(fieldListNode.getItem(0).getStartOffset());
            fieldListNode.setEndOffset(fieldListNode.getItem(fieldListNode.getCount() - 1).getEndOffset());
        }
        return fieldListNode;
    }

    private NodeFieldName scanFieldName(NodeTableName table) {
        Node node = this.TryScanFieldName();
        if (node != null) {
            return (NodeFieldName)node;
        }
        this.throwSyntaxError(SyntaxError.EXPECTING_FIELD_NAME);
        return null;
    }

    private NodeMode ScanMode() {
        this.ensureToken(NodeType.OPERATION, "(", SyntaxError.EXPECTING_LEFT_BRACKET);
        NodeMode mode = new NodeMode();
        do {
            int pos = this.currentPosition;
            NodeItem item = this.nextToken();
            if (item == null || !item.getNodeType().equals(NodeType.NAME)) {
                this.currentPosition = pos;
                this.throwSyntaxError(SyntaxError.EXPECTING_MODE);
                return null;
            }
            mode.add(item);
        } while (this.scanToken(NodeType.OPERATION, ",") != null);
        this.ensureToken(NodeType.OPERATION, ")", SyntaxError.EXPECTING_RIGHT_BRACKET);
        mode.setStartOffset(mode.getItem(0).getStartOffset());
        mode.setEndOffset(mode.getItem(mode.getCount() - 1).getEndOffset());
        return mode;
    }

    private NodeItem ensureToken(NodeType type, String str, SyntaxError syntaxError) {
        NodeItem tokenNode = this.scanToken(type, str);
        if (tokenNode == null) {
            this.throwSyntaxError(syntaxError);
        }
        return tokenNode;
    }

    private void throwSyntaxError(SyntaxError error) {
        NodeItem causeNode = null;
        if (this.currentPosition < this.tokens.size()) {
            causeNode = (NodeItem)this.tokens.get(this.currentPosition);
        }
        throw new SyntaxException(causeNode, error);
    }

    private NodeItem scanToken(NodeType type, String str) {
        int savedCurrentPosition = this.currentPosition;
        NodeItem tokenNode = this.nextToken();
        if (tokenNode != null && tokenNode.getNodeType() == type && str.equalsIgnoreCase(tokenNode.getValue())) {
            return tokenNode;
        }
        this.currentPosition = savedCurrentPosition;
        return null;
    }

    private NodeItem nextToken() {
        if (this.currentPosition < this.tokens.size()) {
            return (NodeItem)this.tokens.get(this.currentPosition++);
        }
        return null;
    }

    private Node TryScanExpression() {
        int num;
        Node node = this.TryScanSingleValue();
        if (node == null) {
            return null;
        }
        while (true) {
            num = this.currentPosition;
            NodeItem item = this.nextToken();
            if (item == null) break;
            Arithmetic none = Arithmetic.NONE;
            Node node2 = null;
            if (item.getNodeType() == NodeType.NUMBER) {
                none = ArithmeticalOperators.find(item.getValue().substring(0, 1));
                if (none != Arithmetic.NONE) {
                    item.setValue(item.getValue().substring(1));
                    node2 = item;
                }
            } else if (item.getNodeType() == NodeType.OPERATION && (none = ArithmeticalOperators.find(item.getValue())) != Arithmetic.NONE) {
                node2 = this.TryScanSingleValue();
            }
            if (none == Arithmetic.NONE || node2 == null) break;
            NodeArithmetic arithmetic2 = new NodeArithmetic();
            arithmetic2.setArithmetic(none);
            arithmetic2.setLeft(node);
            arithmetic2.setRight(node2);
            arithmetic2.setStartOffset(arithmetic2.getLeft().getStartOffset());
            arithmetic2.setEndOffset(arithmetic2.getRight().getEndOffset());
            node = arithmetic2;
        }
        this.currentPosition = num;
        return node;
    }

    private Node TryScanFieldName() {
        NodeFieldName node = null;
        int pos = this.currentPosition;
        NodeItem node2 = this.nextToken();
        if (node2 != null && node2.getNodeType() == NodeType.NAME) {
            NodeItem item = this.scanToken(NodeType.OPERATION, ".");
            NodeItem node3 = null;
            if (item != null) {
                node3 = this.nextToken();
                if (node3 != null && node3.getNodeType() == NodeType.NAME) {
                    node = new NodeFieldName((NodeName)node2, (NodeName)node3);
                }
            } else {
                node = new NodeFieldName((NodeName)node2);
            }
        }
        if (node == null) {
            this.currentPosition = pos;
            return null;
        }
        return node;
    }

    private Node TryScanSingleValue() {
        int pos = this.currentPosition;
        NodeItem node2 = this.nextToken();
        if (node2 != null && (node2.getNodeType() == NodeType.NUMBER || node2.getNodeType() == NodeType.STRING || node2.getNodeType() == NodeType.VARIABLE || node2.getNodeType() == NodeType.BOOL_VALUE)) {
            return node2;
        }
        this.currentPosition = pos;
        return null;
    }
}

