/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.wittype;

import com.microsoft.tfs.core.clients.commonstructure.ProjectInfo;
import com.microsoft.tfs.core.clients.workitem.fields.FieldDefinitionCollection;
import com.microsoft.tfs.core.clients.workitem.form.WIFormDescription;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldDefinitionCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormParseHandler;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.WorkItemTypeMetadata;
import com.microsoft.tfs.core.clients.workitem.internal.project.ProjectImpl;
import com.microsoft.tfs.core.clients.workitem.internal.wittype.NextStateCache;
import com.microsoft.tfs.core.clients.workitem.project.Project;
import com.microsoft.tfs.core.clients.workitem.wittype.WorkItemType;
import com.microsoft.tfs.core.pguidance.ProcessGuidanceURLInfo;
import java.text.MessageFormat;

public class WorkItemTypeImpl
implements WorkItemType {
    private final WorkItemTypeMetadata workItemTypeMetadata;
    private final WITContext witContext;
    private final ProjectImpl project;
    private WIFormDescription formDescription;
    private FieldDefinitionCollectionImpl fieldDefinitionCollection;
    private final NextStateCache nextStateCache;

    public WorkItemTypeImpl(WorkItemTypeMetadata workItemTypeMetadata, ProjectImpl project, WITContext witContext) {
        this.workItemTypeMetadata = workItemTypeMetadata;
        this.project = project;
        this.witContext = witContext;
        this.nextStateCache = new NextStateCache(workItemTypeMetadata.getID(), witContext.getMetadata());
    }

    @Override
    public int compareTo(WorkItemType other) {
        return this.workItemTypeMetadata.getName().compareToIgnoreCase(((WorkItemTypeImpl)other).workItemTypeMetadata.getName());
    }

    @Override
    public String getName() {
        return this.workItemTypeMetadata.getName();
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public int getID() {
        return this.workItemTypeMetadata.getID();
    }

    @Override
    public WIFormDescription getFormDescription() {
        if (this.formDescription == null) {
            this.calculateForm();
        }
        return this.formDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldDefinitionCollection getFieldDefinitions() {
        WorkItemTypeImpl workItemTypeImpl = this;
        synchronized (workItemTypeImpl) {
            if (this.fieldDefinitionCollection == null) {
                this.fieldDefinitionCollection = new FieldDefinitionCollectionImpl(false, this.witContext, this);
            }
            return this.fieldDefinitionCollection;
        }
    }

    @Override
    public ProcessGuidanceURLInfo getProcessGuidanceURL() {
        String typeName = this.workItemTypeMetadata.getName();
        String supportingFilesFolder = "Supporting Files";
        MessageFormat documentPathFormat = new MessageFormat("{0}/{1}");
        String primaryDocumentPath = documentPathFormat.format(new Object[]{"Supporting Files", typeName});
        String[] alternateDocumentPaths = new String[]{documentPathFormat.format(new Object[]{"Supporting Files", typeName.replaceAll(" ", "")}), documentPathFormat.format(new Object[]{"Supporting Files", "AboutWorkItems.htm"}), documentPathFormat.format(new Object[]{"Supporting Files", "ProcessGuidance.html"})};
        return this.witContext.getClient().getProcessGuidance().getProcessGuidanceURL(new ProjectInfo(this.project.getName(), this.project.getURI()), primaryDocumentPath, alternateDocumentPaths);
    }

    public ProjectImpl getProjectInternal() {
        return this.project;
    }

    private void calculateForm() {
        int formId = this.witContext.getMetadata().getRulesTable().getWorkItemFormID(this.getProject().getID(), this.workItemTypeMetadata.getName());
        String formXML = this.witContext.getMetadata().getHierarchyPropertiesTable().getValue(formId);
        this.formDescription = (WIFormDescription)WIFormParseHandler.parse(formXML);
    }

    public String getNextState(String currentState, String action) {
        return this.nextStateCache.getNextState(currentState, action);
    }
}

