/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.query.qe;

import com.microsoft.tfs.core.clients.workitem.fields.FieldDefinition;
import com.microsoft.tfs.core.clients.workitem.fields.FieldDefinitionCollection;
import com.microsoft.tfs.core.clients.workitem.fields.FieldType;
import com.microsoft.tfs.core.clients.workitem.fields.FieldUsages;
import com.microsoft.tfs.core.clients.workitem.query.QueryDocument;
import com.microsoft.tfs.core.clients.workitem.query.qe.DisplayField;
import com.microsoft.tfs.core.clients.workitem.query.qe.DisplayFieldCollection;
import com.microsoft.tfs.core.clients.workitem.query.qe.SortFieldCollection;
import com.microsoft.tfs.core.memento.Memento;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.Iterator;

public class ResultOptions {
    public static final int CHANGE_TYPE_NONE = 0;
    public static final int CHANGE_TYPE_WIDTHS = 1;
    public static final int CHANGE_TYPE_COLUMNS = 2;
    public static final int CHANGE_TYPE_SORT = 4;
    private static final String COLUMN_MEMENTO_NAME = "column";
    private static final String COLUMN_NAME_NAME = "name";
    private static final String WIDTH_NAME = "width";
    private static final String DESC = " desc";
    private static final String ORDER_BY = "ORDER BY";
    private static final String SELECT = "SELECT";
    private DisplayFieldCollection displayFields;
    private SortFieldCollection sortFields;
    private final QueryDocument queryDocument;

    public static boolean checkChangeFlag(int flags, int flagToCheck) {
        return (flags & flagToCheck) == flagToCheck;
    }

    public static int determineChange(ResultOptions orig, ResultOptions current) {
        int i;
        int changeType = 0;
        if (orig.getDisplayFields().getCount() != current.getDisplayFields().getCount()) {
            changeType |= 1;
            changeType |= 2;
        } else {
            for (i = 0; i < orig.getDisplayFields().getCount(); ++i) {
                if (orig.getDisplayFields().get(i).getFieldName().equals(current.getDisplayFields().get(i).getFieldName())) continue;
                changeType |= 1;
                changeType |= 2;
                break;
            }
        }
        if (!ResultOptions.checkChangeFlag(changeType, 2)) {
            for (i = 0; i < orig.getDisplayFields().getCount(); ++i) {
                if (orig.getDisplayFields().get(i).getWidth() == current.getDisplayFields().get(i).getWidth()) continue;
                changeType |= 1;
                break;
            }
        }
        if (orig.getSortFields().getCount() != current.getSortFields().getCount()) {
            return changeType | 4;
        }
        for (i = 0; i < orig.getSortFields().getCount(); ++i) {
            if (orig.getSortFields().get(i).getFieldName().equals(current.getSortFields().get(i).getFieldName()) && orig.getSortFields().get(i).isAscending() == current.getSortFields().get(i).isAscending()) continue;
            return changeType | 4;
        }
        return changeType;
    }

    public static int getDefaultColumnWidth(String fieldName, FieldDefinitionCollection fieldDefinitions) {
        if (fieldDefinitions != null && fieldDefinitions.contains(fieldName)) {
            FieldDefinition fieldDefinition = fieldDefinitions.get(fieldName);
            return ResultOptions.getDefaultColumnWidth(fieldDefinition);
        }
        return 75;
    }

    public static int getDefaultColumnWidth(FieldDefinition fieldDefinition) {
        if (fieldDefinition.getID() == 1) {
            return 450;
        }
        FieldType type = fieldDefinition.getFieldType();
        if (type == FieldType.INTEGER) {
            return 50;
        }
        if (type == FieldType.DATETIME) {
            return 120;
        }
        if (type == FieldType.TREEPATH) {
            return 300;
        }
        return 75;
    }

    public ResultOptions(QueryDocument queryDocument) {
        this.queryDocument = queryDocument;
        this.createCollections();
    }

    public ResultOptions(DisplayFieldCollection displayFields, SortFieldCollection sortFields, QueryDocument queryDocument) {
        this.displayFields = displayFields;
        this.sortFields = sortFields;
        this.queryDocument = queryDocument;
        this.createCollections();
    }

    public ResultOptions(ResultOptions existingOptions, boolean makeDeepCopy, QueryDocument queryDocument) {
        this.queryDocument = queryDocument;
        if (makeDeepCopy) {
            this.displayFields = new DisplayFieldCollection(existingOptions.getDisplayFields());
            this.sortFields = new SortFieldCollection(existingOptions.getSortFields());
        } else {
            this.displayFields = existingOptions.displayFields;
            this.sortFields = existingOptions.sortFields;
        }
        this.createCollections();
    }

    public boolean isLinkQuery() {
        return this.queryDocument.isLinkQuery() || this.queryDocument.isTreeQuery();
    }

    public void onQueryTypeChanged(FieldDefinitionCollection fieldDefinitions) {
        FieldDefinition linkTypeDefinition = null;
        if (fieldDefinitions.contains("System.Links.LinkType")) {
            linkTypeDefinition = fieldDefinitions.get("System.Links.LinkType");
        }
        if (linkTypeDefinition == null) {
            return;
        }
        String linkTypeName = linkTypeDefinition.getName();
        if (this.queryDocument.isLinkQuery() && !this.queryDocument.isTreeQuery()) {
            boolean hasLinkType = false;
            for (int i = 0; i < this.displayFields.getCount(); ++i) {
                DisplayField field = this.displayFields.get(i);
                if (!field.getFieldName().equals(linkTypeName)) continue;
                hasLinkType = true;
                break;
            }
            if (!hasLinkType) {
                this.displayFields.add(new DisplayField(linkTypeName, ResultOptions.getDefaultColumnWidth(linkTypeDefinition)));
            }
        } else {
            DisplayField field;
            int i;
            for (i = 0; i < this.displayFields.getCount(); ++i) {
                field = this.displayFields.get(i);
                if (!field.getFieldName().equals(linkTypeName)) continue;
                this.displayFields.removeAt(i);
            }
            for (i = 0; i < this.sortFields.getCount(); ++i) {
                field = this.sortFields.get(i);
                if (!field.getFieldName().equals(linkTypeName)) continue;
                this.sortFields.removeAt(i);
            }
        }
    }

    public void saveToMemento(Memento memento) {
        Check.notNull(memento, "memento");
        Iterator<DisplayField> it = this.displayFields.iterator();
        while (it.hasNext()) {
            DisplayField displayField = it.next();
            Memento child = memento.createChild(COLUMN_MEMENTO_NAME);
            child.putString(COLUMN_NAME_NAME, displayField.getFieldName());
            child.putInteger(WIDTH_NAME, displayField.getWidth());
        }
    }

    public void loadFromMemento(Memento memento) {
        if (memento == null) {
            return;
        }
        Memento[] columns = memento.getChildren(COLUMN_MEMENTO_NAME);
        for (int i = 0; i < columns.length; ++i) {
            String name = columns[i].getString(COLUMN_NAME_NAME);
            int width = columns[i].getInteger(WIDTH_NAME);
            this.setColumnWidth(name, width);
        }
    }

    private void createCollections() {
        if (this.displayFields == null) {
            this.displayFields = new DisplayFieldCollection();
        }
        if (this.sortFields == null) {
            this.sortFields = new SortFieldCollection();
        }
    }

    public String getOrderByClause(FieldDefinitionCollection fieldDefinitions) {
        int count = this.sortFields.getCount();
        if (count == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(ORDER_BY);
        for (int i = 0; i < count; ++i) {
            String name = DisplayField.getInvariantFieldName(this.sortFields.get(i).getFieldName(), fieldDefinitions);
            FieldDefinition fieldDefinition = fieldDefinitions.get(name);
            if (fieldDefinition.getUsage() == FieldUsages.WORK_ITEM_LINK && !this.isLinkQuery()) continue;
            name = fieldDefinition.getReferenceName();
            if (i == 0) {
                buffer.append(MessageFormat.format(" [{0}]", name));
            } else {
                buffer.append(MessageFormat.format(", [{0}]", name));
            }
            if (this.sortFields.get(i).isAscending()) continue;
            buffer.append(DESC);
        }
        return buffer.toString();
    }

    public String getSelectClause(FieldDefinitionCollection fieldDefinitions) {
        int count = this.displayFields.getCount();
        if (count == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(SELECT);
        for (int i = 0; i < count; ++i) {
            String name = DisplayField.getInvariantFieldName(this.displayFields.get(i).getFieldName(), fieldDefinitions);
            FieldDefinition fieldDefinition = fieldDefinitions.get(name);
            if (fieldDefinition.getUsage() == FieldUsages.WORK_ITEM_LINK && !this.isLinkQuery()) continue;
            name = fieldDefinition.getReferenceName();
            if (i == 0) {
                buffer.append(MessageFormat.format(" [{0}]", name));
                continue;
            }
            buffer.append(MessageFormat.format(", [{0}]", name));
        }
        return buffer.toString();
    }

    private void setColumnWidth(String name, int width) {
        Iterator<DisplayField> it = this.displayFields.iterator();
        while (it.hasNext()) {
            DisplayField displayField = it.next();
            if (!displayField.getFieldName().equals(name)) continue;
            displayField.setWidth(width);
        }
    }

    public DisplayFieldCollection getDisplayFields() {
        return this.displayFields;
    }

    public SortFieldCollection getSortFields() {
        return this.sortFields;
    }
}

