/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.query.qe;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.CollatorFactory;
import java.text.MessageFormat;
import java.util.Map;
import java.util.TreeMap;

public final class WIQLOperators {
    public static final String PROJECT_CONTEXT_KEY = "project";
    public static final String TEAM_NAME_CONTEXT_KEY = "team";
    public static final String CURRENT_ITERATION_CONTEXT_KEY = "currentIteration";
    public static final String AND = "AND";
    public static final String CONTAINS = "CONTAINS";
    public static final String CONTAINS_WORDS = "CONTAINS WORDS";
    public static final String EQUAL_TO = "=";
    public static final String EVER = "EVER";
    public static final String GREATER_THAN = ">";
    public static final String GREATER_THAN_OR_EQUAL_TO = ">=";
    public static final String IN = "IN";
    public static final String LESS_THAN = "<";
    public static final String LESS_THAN_OR_EQUAL_TO = "<=";
    public static final String MACRO_ME = "@me";
    public static final String MACRO_PROJECT = "@project";
    public static final String MACRO_CURRENT_ITERATION = "@currentIteration";
    public static final String MACRO_TODAY = "@today";
    public static final String SPECIAL_ANY = "[Any]";
    public static final String NOT_ = "NOT ";
    public static final String NOT_CONTAINS = "NOT CONTAINS";
    public static final String NOT_CONTAINS_WORDS = "NOT CONTAINS WORDS";
    public static final String NOT_EQUAL_TO = "<>";
    public static final String NOT_EVER = "NOT EVER";
    public static final String NOT_UNDER = "NOT UNDER";
    public static final String OR = "OR";
    public static final String UNDER = "UNDER";
    public static final String IN_GROUP = "IN GROUP";
    public static final String NOT_IN_GROUP = "NOT IN GROUP";
    public static final String EQUAL_TO_FIELD = "= ";
    public static final String NOT_EQUAL_TO_FIELD = "<> ";
    public static final String GREATER_THAN_FIELD = "> ";
    public static final String LESS_THAN_FIELD = "< ";
    public static final String GREATER_THAN_OR_EQUAL_TO_FIELD = ">= ";
    public static final String LESS_THAN_OR_EQUAL_TO_FIELD = "<= ";
    private static final Map<String, String> localizedOperatorLookup = new TreeMap<Object, String>(CollatorFactory.getCaseInsensitiveCollator());
    private static final Map<String, String> invariantOperatorLookup = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    private WIQLOperators() {
    }

    private static void addOperatorPair(String invariantOperator, String localizedOperator) {
        localizedOperatorLookup.put(invariantOperator, localizedOperator);
        invariantOperatorLookup.put(localizedOperator, invariantOperator);
    }

    public static String getInvariantOperator(String localizedOperator) {
        Check.notNull(localizedOperator, "localizedOperator");
        if (invariantOperatorLookup.containsKey(localizedOperator)) {
            return invariantOperatorLookup.get(localizedOperator);
        }
        return localizedOperator;
    }

    public static String getLocalizedOperator(String invariantOperator) {
        Check.notNull(invariantOperator, "invariantOperator");
        if (localizedOperatorLookup.containsKey(invariantOperator)) {
            return localizedOperatorLookup.get(invariantOperator);
        }
        return invariantOperator;
    }

    public static String getLocalizedTodayMinusMacro(int number) {
        return MessageFormat.format("{0} - {1}", WIQLOperators.getLocalizedOperator(MACRO_TODAY), Integer.toString(number));
    }

    public static String getLocalizedTodayMinusMacro(String invariantValue) {
        return WIQLOperators.getLocalizedOperator(MACRO_TODAY) + invariantValue.substring(MACRO_TODAY.length());
    }

    public static String getInvariantTodayMinusMacro(String localizedValue) {
        return MACRO_TODAY + localizedValue.substring(WIQLOperators.getLocalizedOperator(MACRO_TODAY).length());
    }

    public static LogicalOperator getLogicalOperator(String logicalOperatorText) {
        if (WIQLOperators.getInvariantOperator(logicalOperatorText).equals(AND)) {
            return LogicalOperator.AND;
        }
        if (WIQLOperators.getInvariantOperator(logicalOperatorText).equals(OR)) {
            return LogicalOperator.OR;
        }
        return LogicalOperator.NONE;
    }

    public static boolean isGroupOperator(String op) {
        return op == IN_GROUP || op == NOT_IN_GROUP;
    }

    public static boolean isFieldNameOperator(String op) {
        return op == EQUAL_TO_FIELD || op == NOT_EQUAL_TO_FIELD || op == LESS_THAN_FIELD || op == GREATER_THAN_FIELD || op == LESS_THAN_OR_EQUAL_TO_FIELD || op == GREATER_THAN_OR_EQUAL_TO_FIELD;
    }

    public static boolean isContainsOperator(String op) {
        return op.equalsIgnoreCase(CONTAINS) || op.equalsIgnoreCase(NOT_CONTAINS);
    }

    public static boolean isContainsWordsOperator(String op) {
        return op.equalsIgnoreCase(CONTAINS_WORDS) || op.equalsIgnoreCase(NOT_CONTAINS_WORDS);
    }

    static {
        WIQLOperators.addOperatorPair(AND, Messages.getString("WiqlOperators.And"));
        WIQLOperators.addOperatorPair(OR, Messages.getString("WiqlOperators.Or"));
        WIQLOperators.addOperatorPair(CONTAINS, Messages.getString("WiqlOperators.Contains"));
        WIQLOperators.addOperatorPair(CONTAINS_WORDS, Messages.getString("WIQLOperators.ContainsWords"));
        WIQLOperators.addOperatorPair(NOT_CONTAINS, Messages.getString("WiqlOperators.NotContains"));
        WIQLOperators.addOperatorPair(NOT_CONTAINS_WORDS, Messages.getString("WIQLOperators.NotContainsWords"));
        WIQLOperators.addOperatorPair(IN, Messages.getString("WiqlOperators.In"));
        WIQLOperators.addOperatorPair(IN_GROUP, Messages.getString("WiqlOperators.InGroup"));
        WIQLOperators.addOperatorPair(NOT_IN_GROUP, Messages.getString("WiqlOperators.NotInGroup"));
        WIQLOperators.addOperatorPair(EVER, Messages.getString("WiqlOperators.Ever"));
        WIQLOperators.addOperatorPair(NOT_EVER, Messages.getString("WiqlOperators.NotEver"));
        WIQLOperators.addOperatorPair(UNDER, Messages.getString("WiqlOperators.Under"));
        WIQLOperators.addOperatorPair(NOT_UNDER, Messages.getString("WiqlOperators.NotUnder"));
        WIQLOperators.addOperatorPair(EQUAL_TO, Messages.getString("WiqlOperators.EqualTo"));
        WIQLOperators.addOperatorPair(NOT_EQUAL_TO, Messages.getString("WiqlOperators.NotEqualTo"));
        WIQLOperators.addOperatorPair(GREATER_THAN, Messages.getString("WiqlOperators.GreaterThan"));
        WIQLOperators.addOperatorPair(LESS_THAN, Messages.getString("WiqlOperators.LessThan"));
        WIQLOperators.addOperatorPair(GREATER_THAN_OR_EQUAL_TO, Messages.getString("WiqlOperators.GreaterThanOrEqualTo"));
        WIQLOperators.addOperatorPair(LESS_THAN_OR_EQUAL_TO, Messages.getString("WiqlOperators.LessThanOrEqualTo"));
        WIQLOperators.addOperatorPair(EQUAL_TO_FIELD, Messages.getString("WiqlOperators.EqualToField"));
        WIQLOperators.addOperatorPair(NOT_EQUAL_TO_FIELD, Messages.getString("WiqlOperators.NotEqualToField"));
        WIQLOperators.addOperatorPair(GREATER_THAN_FIELD, Messages.getString("WiqlOperators.GreaterThanField"));
        WIQLOperators.addOperatorPair(LESS_THAN_FIELD, Messages.getString("WiqlOperators.LessThanField"));
        WIQLOperators.addOperatorPair(GREATER_THAN_OR_EQUAL_TO_FIELD, Messages.getString("WiqlOperators.GreaterThanOrEqualToField"));
        WIQLOperators.addOperatorPair(LESS_THAN_OR_EQUAL_TO_FIELD, Messages.getString("WiqlOperators.LessThanOrEqualToField"));
        WIQLOperators.addOperatorPair(SPECIAL_ANY, Messages.getString("WiqlOperators.SpecialAny"));
        WIQLOperators.addOperatorPair(MACRO_TODAY, "@" + Messages.getString("WiqlOperators.MacroTodayWithoutInitialAtSign"));
        WIQLOperators.addOperatorPair(MACRO_ME, "@" + Messages.getString("WiqlOperators.MacroMeWithoutInitialAtSign"));
        WIQLOperators.addOperatorPair(MACRO_PROJECT, "@" + Messages.getString("WiqlOperators.MacroProjectWithoutInitialAtSign"));
        WIQLOperators.addOperatorPair(MACRO_CURRENT_ITERATION, "@" + Messages.getString("WIQLOperators.MacroCurrentIterationWithoutInitialAtSign"));
    }

    public static class LogicalOperator {
        public static final LogicalOperator AND = new LogicalOperator(0);
        public static final LogicalOperator NONE = new LogicalOperator(-1);
        public static final LogicalOperator OR = new LogicalOperator(1);
        private final int value;

        private LogicalOperator(int value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

