/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.config.tfproxy;

import com.microsoft.tfs.core.TFProxyServerSettings;
import com.microsoft.tfs.core.config.ConnectionInstanceData;
import com.microsoft.tfs.core.config.RegistryUtils;
import com.microsoft.tfs.core.config.tfproxy.DefaultTFProxyServerSettings;
import com.microsoft.tfs.core.config.tfproxy.TFProxyServerSettingsFactory;
import com.microsoft.tfs.jni.PlatformMiscUtils;
import com.microsoft.tfs.jni.RegistryKey;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Platform;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultTFProxyServerSettingsFactory
implements TFProxyServerSettingsFactory {
    private static final Log log = LogFactory.getLog(DefaultTFProxyServerSettings.class);
    private static final String REGISTRY_PATH = "TeamFoundation\\SourceControl\\Proxy";
    private static final String PROXY_ENABLED = "Enabled";
    private static final String PROXY_URL = "Url";
    private static final String PROXY_RETRY_INTERVAL = "RetryInterval";

    public DefaultTFProxyServerSettingsFactory(ConnectionInstanceData connectionInstanceData) {
        Check.notNull(connectionInstanceData, "connectionInstanceData");
    }

    @Override
    public TFProxyServerSettings newProxyServerSettings() {
        TFProxyServerSettings settings = this.configureFromEnvironmentVariable();
        if (settings == null && Platform.isCurrentPlatform(Platform.WINDOWS)) {
            settings = this.configureFromRegistry();
        }
        if (settings == null) {
            log.debug((Object)"No TF proxy specified");
        }
        return settings;
    }

    @Override
    public void dispose(TFProxyServerSettings proxyServerSettings) {
    }

    protected TFProxyServerSettings configureFromEnvironmentVariable() {
        String environmentURL = PlatformMiscUtils.getInstance().getEnvironmentVariable("TFSPROXY");
        if (environmentURL != null && environmentURL.length() > 0) {
            log.debug((Object)MessageFormat.format("Environment variable {0} set, using TF proxy URL {1}", "TFSPROXY", environmentURL));
            return new DefaultTFProxyServerSettings(environmentURL);
        }
        return null;
    }

    protected TFProxyServerSettings configureFromRegistry() {
        RegistryKey registryKey;
        RegistryKey userKey = RegistryUtils.openOrCreateRootUserRegistryKey();
        if (userKey != null && (registryKey = userKey.getSubkey(REGISTRY_PATH)) != null) {
            String proxyURL = registryKey.getStringValue(PROXY_URL, "");
            boolean enabled = Boolean.parseBoolean(registryKey.getStringValue(PROXY_ENABLED, "false"));
            int proxyRetryIntervalMinutes = registryKey.getIntegerValue(PROXY_RETRY_INTERVAL, 5);
            if (enabled && proxyURL != null && proxyURL.length() > 0) {
                log.debug((Object)MessageFormat.format("Registry key {0} specifies (enabled) proxy URL {1}", registryKey.toString(), proxyURL));
                return new DefaultTFProxyServerSettings(proxyURL, proxyRetryIntervalMinutes * 60 * 1000);
            }
        }
        return null;
    }
}

