/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.credentials.internal;

import com.microsoft.alm.secret.Credential;
import com.microsoft.alm.secret.Secret;
import com.microsoft.alm.storage.posix.GnomeKeyringBackedCredentialStore;
import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.credentials.CachedCredentials;
import com.microsoft.tfs.core.credentials.CredentialsManager;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.StringUtil;
import java.net.URI;

public class GnomeKeyringCredentialsManager
implements CredentialsManager {
    private static final GnomeKeyringBackedCredentialStore gnomeKeyringStore = GnomeKeyringBackedCredentialStore.isGnomeKeyringSupported() ? new GnomeKeyringBackedCredentialStore() : null;

    public static boolean isGnomeKeyringSupported() {
        return gnomeKeyringStore != null;
    }

    @Override
    public String getUIMechanismName() {
        return Messages.getString("GnomeKeyringCredentialsManager.GnomeKeyring");
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public CachedCredentials[] getCredentials() {
        return null;
    }

    @Override
    public CachedCredentials getCredentials(URI serverURI) {
        Credential cred;
        Check.notNull(serverURI, "serverURI");
        serverURI = URIUtils.removePathAndQueryParts(serverURI);
        if (gnomeKeyringStore != null && (cred = (Credential)gnomeKeyringStore.get(this.getKey(serverURI))) != null && !StringUtil.isNullOrEmpty(cred.Password) && !StringUtil.isNullOrEmpty(cred.Username)) {
            return new CachedCredentials(serverURI, cred.Username, cred.Password);
        }
        return null;
    }

    @Override
    public boolean setCredentials(CachedCredentials cachedCredentials) {
        Check.notNull(cachedCredentials, "cachedCredentials");
        Check.notNull(cachedCredentials.getURI(), "cachedCredentials.getURI()");
        if (gnomeKeyringStore == null) {
            return false;
        }
        URI serverURI = URIUtils.removePathAndQueryParts(cachedCredentials.getURI());
        cachedCredentials = new CachedCredentials(serverURI, cachedCredentials.getUsername(), cachedCredentials.getPassword());
        Credential cred = new Credential(cachedCredentials.getUsername(), cachedCredentials.getPassword());
        return gnomeKeyringStore.add(this.getKey(serverURI), (Secret)cred);
    }

    @Override
    public boolean removeCredentials(CachedCredentials cachedCredentials) {
        Check.notNull(cachedCredentials, "cachedCredentials");
        Check.notNull(cachedCredentials.getURI(), "cachedCredentials.getURI()");
        return this.removeCredentials(cachedCredentials.getURI());
    }

    @Override
    public boolean removeCredentials(URI uri) {
        Check.notNull(uri, "uri");
        if (gnomeKeyringStore == null) {
            return false;
        }
        URI serverURI = URIUtils.removePathAndQueryParts(uri);
        return gnomeKeyringStore.delete(this.getKey(serverURI));
    }

    private String getKey(URI serverURI) {
        return Secret.DefaultUriNameConversion.convert(serverURI, "tee");
    }
}

