/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.internal.db.dao;

import com.microsoft.tfs.core.internal.db.ConnectionPool;
import com.microsoft.tfs.core.internal.db.DBConnection;
import com.microsoft.tfs.core.internal.db.dao.DBConnectionSource;
import com.microsoft.tfs.core.internal.db.dao.InitializableDAO;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseDAOFactory {
    private final Map implementationClasses = new HashMap();
    private final Map daoObjects = new HashMap();
    private boolean initialized = false;
    private final ConnectionPool connectionPool;

    protected abstract void doAddImplementationMappings();

    protected abstract void doInitializeDAOImplementation(Object var1);

    public BaseDAOFactory(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public synchronized Object getDAO(Class daoInterfaceClass) {
        InitializableDAO implementaion;
        Class implementationClass;
        if (this.daoObjects.containsKey(daoInterfaceClass)) {
            return this.daoObjects.get(daoInterfaceClass);
        }
        if (!this.initialized) {
            this.initialize();
        }
        if ((implementationClass = (Class)this.implementationClasses.get(daoInterfaceClass)) == null) {
            throw new IllegalArgumentException(MessageFormat.format("the dao interface [{0}] does not have an implementation registered with this factory", daoInterfaceClass.getName()));
        }
        try {
            implementaion = (InitializableDAO)this.instantiate(implementationClass);
        }
        catch (Exception e) {
            throw new RuntimeException(MessageFormat.format("unable to instantiate dao implementation [{0}]", implementationClass.getName()), e);
        }
        TLSConnectionSource connectionSource = new TLSConnectionSource();
        implementaion.initialize(connectionSource);
        this.doInitializeDAOImplementation(implementaion);
        Object dao = Proxy.newProxyInstance(daoInterfaceClass.getClassLoader(), new Class[]{daoInterfaceClass}, (InvocationHandler)new DAOProxy(implementaion, connectionSource, this.connectionPool));
        this.daoObjects.put(daoInterfaceClass, dao);
        return dao;
    }

    protected Object instantiate(Class cls) throws InstantiationException, IllegalAccessException {
        return cls.newInstance();
    }

    private void initialize() {
        this.initialized = true;
        this.doAddImplementationMappings();
    }

    protected void addImplementation(Class interfaceClass, Class implementationClass) {
        this.implementationClasses.put(interfaceClass, implementationClass);
    }

    private static class TLSConnectionSource
    implements DBConnectionSource {
        private final ThreadLocal connectionTLS = new ThreadLocal();

        private TLSConnectionSource() {
        }

        public void setConnection(DBConnection connection) {
            this.connectionTLS.set(connection);
        }

        public void clearConnection() {
            this.connectionTLS.set(null);
        }

        @Override
        public DBConnection getConnection() {
            return (DBConnection)this.connectionTLS.get();
        }
    }

    private static class DAOProxy
    implements InvocationHandler {
        private final Object delegate;
        private final TLSConnectionSource connectionSource;
        private final ConnectionPool connectionPool;

        public DAOProxy(Object delegate, TLSConnectionSource connectionSource, ConnectionPool connectionPool) {
            this.delegate = delegate;
            this.connectionSource = connectionSource;
            this.connectionPool = connectionPool;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            DBConnection connection = this.connectionPool.getConnection();
            this.connectionSource.setConnection(connection);
            try {
                Object object = method.invoke(this.delegate, args);
                return object;
            }
            catch (InvocationTargetException ex) {
                throw ex.getCause();
            }
            finally {
                this.connectionSource.clearConnection();
                this.connectionPool.releaseConnection(connection);
            }
        }
    }
}

