/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.memento;

import com.microsoft.tfs.core.memento.Memento;
import com.microsoft.tfs.core.memento.MementoException;
import com.microsoft.tfs.core.ws.runtime.stax.StaxFactoryProvider;
import com.microsoft.tfs.util.Check;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLMemento
implements Memento {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final Log log = LogFactory.getLog(XMLMemento.class);
    private final String name;
    private String textData;
    private final Map attributes = new HashMap();
    private final List children = new ArrayList();

    public static XMLMemento read(InputStream inputStream, String encoding) throws MementoException {
        Check.notNull(inputStream, "inputStream");
        try {
            int event;
            XMLStreamReader reader = StaxFactoryProvider.getXMLInputFactory(true).createXMLStreamReader(inputStream, encoding != null ? encoding : DEFAULT_ENCODING);
            XMLMemento memento = null;
            do {
                if ((event = reader.next()) != 1) continue;
                String localName = reader.getLocalName();
                memento = new XMLMemento(localName);
                memento.readFromElement(reader);
            } while (event != 2 && event != 8);
            reader.close();
            return memento;
        }
        catch (XMLStreamException e) {
            log.error((Object)"Error reading", (Throwable)e);
            throw new MementoException(e);
        }
    }

    private synchronized void readFromElement(XMLStreamReader reader) throws XMLStreamException {
        int event;
        Check.notNull(reader, "reader");
        int attributeCount = reader.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            this.putString(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
        }
        do {
            if ((event = reader.next()) == 1) {
                String localName = reader.getLocalName();
                XMLMemento child = (XMLMemento)this.createChild(localName);
                child.readFromElement(reader);
                continue;
            }
            if (event != 4) continue;
            this.putTextData(reader.getText());
        } while (event != 2);
    }

    public synchronized void write(OutputStream outputStream, String encoding) throws MementoException {
        Check.notNull(outputStream, "outputStream");
        try {
            XMLStreamWriter writer = StaxFactoryProvider.getXMLOutputFactory().createXMLStreamWriter(outputStream, encoding != null ? encoding : DEFAULT_ENCODING);
            this.writeAsElement(writer);
            writer.close();
        }
        catch (XMLStreamException e) {
            log.error((Object)"Error saving", (Throwable)e);
            throw new MementoException(e);
        }
    }

    private void writeAsElement(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(this.name);
        for (Map.Entry entry : this.attributes.entrySet()) {
            writer.writeAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        if (this.textData != null) {
            writer.writeCharacters(this.textData);
        }
        for (XMLMemento child : this.children) {
            child.writeAsElement(writer);
        }
        writer.writeEndElement();
    }

    public XMLMemento(String name) {
        Check.notNullOrEmpty(name, "name");
        this.name = name;
    }

    @Override
    public synchronized String getName() {
        return this.name;
    }

    @Override
    public synchronized Memento createChild(String name) {
        Check.notNullOrEmpty(name, "name");
        XMLMemento child = new XMLMemento(name);
        this.children.add(child);
        return child;
    }

    @Override
    public synchronized Memento getChild(String name) {
        Check.notNullOrEmpty(name, "name");
        for (Memento child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    @Override
    public synchronized Memento[] getChildren(String name) {
        Check.notNullOrEmpty(name, "name");
        ArrayList<Memento> results = new ArrayList<Memento>();
        for (Memento child : this.children) {
            if (!child.getName().equals(name)) continue;
            results.add(child);
        }
        return results.toArray(new Memento[results.size()]);
    }

    @Override
    public synchronized Memento[] getAllChildren() {
        return this.children.toArray(new Memento[this.children.size()]);
    }

    @Override
    public synchronized Memento[] removeChildren(String name) {
        Check.notNullOrEmpty(name, "name");
        Memento[] matches = this.getChildren(name);
        this.children.removeAll(Arrays.asList(matches));
        return matches;
    }

    @Override
    public synchronized boolean removeChild(Memento memento) {
        Check.notNull(memento, "memento");
        return this.children.remove(memento);
    }

    @Override
    public synchronized Map getAllAttributes() {
        return new HashMap(this.attributes);
    }

    @Override
    public synchronized Double getDouble(String key) {
        Check.notNullOrEmpty(key, "key");
        String value = (String)this.attributes.get(key);
        if (value == null) {
            return null;
        }
        try {
            return new Double(value);
        }
        catch (NumberFormatException e) {
            log.warn((Object)MessageFormat.format("Invalid double for key: {0} value: {1}", key, value), (Throwable)e);
            return null;
        }
    }

    @Override
    public synchronized Float getFloat(String key) {
        Check.notNullOrEmpty(key, "key");
        String value = (String)this.attributes.get(key);
        if (value == null) {
            return null;
        }
        try {
            return new Float(value);
        }
        catch (NumberFormatException e) {
            log.warn((Object)MessageFormat.format("Invalid float for key: {0} value: {1}", key, value), (Throwable)e);
            return null;
        }
    }

    @Override
    public synchronized Integer getInteger(String key) {
        Check.notNullOrEmpty(key, "key");
        String value = (String)this.attributes.get(key);
        if (value == null) {
            return null;
        }
        try {
            return new Integer(value);
        }
        catch (NumberFormatException e) {
            log.warn((Object)MessageFormat.format("Invalid integer for key: {0} value: {1}", key, value), (Throwable)e);
            return null;
        }
    }

    @Override
    public synchronized Long getLong(String key) {
        Check.notNullOrEmpty(key, "key");
        String value = (String)this.attributes.get(key);
        if (value == null) {
            return null;
        }
        try {
            return new Long(value);
        }
        catch (NumberFormatException e) {
            log.warn((Object)MessageFormat.format("Invalid long integer for key: {0} value: {1}", key, value), (Throwable)e);
            return null;
        }
    }

    @Override
    public synchronized String getString(String key) {
        Check.notNullOrEmpty(key, "key");
        return (String)this.attributes.get(key);
    }

    @Override
    public synchronized Boolean getBoolean(String key) {
        Check.notNullOrEmpty(key, "key");
        String value = (String)this.attributes.get(key);
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    @Override
    public synchronized String getTextData() {
        return this.textData;
    }

    @Override
    public synchronized void putDouble(String key, double value) {
        Check.notNullOrEmpty(key, "key");
        this.attributes.put(key, String.valueOf(value));
    }

    @Override
    public synchronized void putFloat(String key, float value) {
        Check.notNullOrEmpty(key, "key");
        this.attributes.put(key, String.valueOf(value));
    }

    @Override
    public synchronized void putInteger(String key, int value) {
        Check.notNullOrEmpty(key, "key");
        this.attributes.put(key, String.valueOf(value));
    }

    @Override
    public synchronized void putLong(String key, long value) {
        Check.notNullOrEmpty(key, "key");
        this.attributes.put(key, String.valueOf(value));
    }

    @Override
    public synchronized void putString(String key, String value) {
        Check.notNullOrEmpty(key, "key");
        this.attributes.put(key, value);
    }

    @Override
    public synchronized void putBoolean(String key, boolean value) {
        Check.notNullOrEmpty(key, "key");
        this.attributes.put(key, String.valueOf(value));
    }

    @Override
    public synchronized void putTextData(String data) {
        this.textData = data;
    }

    @Override
    public synchronized void putMemento(Memento memento) {
        Check.notNull(memento, "memento");
        String otherText = memento.getTextData();
        if (otherText != null) {
            this.putTextData(memento.getTextData());
        }
        this.attributes.putAll(memento.getAllAttributes());
        Memento[] allChildren = memento.getAllChildren();
        for (int i = 0; i < allChildren.length; ++i) {
            Memento child = this.createChild(allChildren[i].getName());
            child.putMemento(allChildren[i]);
        }
    }
}

