/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util;

import com.microsoft.tfs.core.exceptions.TECoreException;
import com.microsoft.tfs.core.util.CodePageData;
import com.microsoft.tfs.util.Check;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CodePageMapping {
    private static final Log log = LogFactory.getLog(CodePageData.class);
    private static final String charsetMappingKey = "charsetMapping";
    private static final String codePageMappingKey = "codePageMapping";

    public static Charset[] getCharsets() {
        ArrayList<Charset> charsetList = new ArrayList<Charset>();
        ArrayList<String> charsetNameList = new ArrayList<String>();
        charsetNameList.addAll(Arrays.asList(CodePageData.getCharsetNames()));
        charsetNameList.addAll(Arrays.asList(CodePageMapping.getSystemPropertyKeys(charsetMappingKey)));
        for (String charsetName : charsetNameList) {
            Charset charset;
            if (!CodePageMapping.tryCharsetIsSupported(charsetName) || (charset = CodePageMapping.tryCharsetForName(charsetName)) == null || charsetList.contains(charset)) continue;
            charsetList.add(charset);
        }
        return charsetList.toArray(new Charset[charsetList.size()]);
    }

    public static int[] getCodePages() {
        ArrayList<Integer> codePageList = new ArrayList<Integer>();
        codePageList.addAll(Arrays.asList(CodePageData.getCodePages()));
        String[] codePageStrings = CodePageMapping.getSystemPropertyKeys(codePageMappingKey);
        for (int i = 0; i < codePageStrings.length; ++i) {
            try {
                Integer codePage = new Integer(codePageStrings[i]);
                if (codePageList.contains(codePage)) continue;
                codePageList.add(codePage);
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int[] codePages = new int[codePageList.size()];
        for (int i = 0; i < codePageList.size(); ++i) {
            codePages[i] = (Integer)codePageList.get(i);
        }
        return codePages;
    }

    private static String[] getSystemPropertyKeys(String keyPrefix) {
        ArrayList<String> propertyKeyList = new ArrayList<String>();
        Properties systemProperties = System.getProperties();
        for (String string : systemProperties.keySet()) {
            if (!string.startsWith(keyPrefix + ".")) continue;
            String keyConfigurationPart = string.substring(keyPrefix.length() + 2);
            propertyKeyList.add(keyConfigurationPart);
        }
        return propertyKeyList.toArray(new String[propertyKeyList.size()]);
    }

    public static String getEncoding(int codePage) {
        return CodePageMapping.getEncoding(codePage, true, true);
    }

    public static String getEncoding(int codePage, boolean mustExist, boolean mustBeSupportedCharset) {
        String[] charsetNames = CodePageMapping.getCharsetNamesForCodePage(codePage, mustExist);
        if (charsetNames == null) {
            return null;
        }
        for (int i = 0; i < charsetNames.length; ++i) {
            if (!CodePageMapping.tryCharsetIsSupported(charsetNames[i])) continue;
            return charsetNames[i];
        }
        if (!mustBeSupportedCharset) {
            return charsetNames[0];
        }
        throw new UnknownCodePageException(codePage);
    }

    public static Charset getCharset(int codePage) {
        return CodePageMapping.getCharset(codePage, true);
    }

    public static Charset getCharset(int codePage, boolean mustExist) {
        String[] charsetNames = CodePageMapping.getCharsetNamesForCodePage(codePage, mustExist);
        if (charsetNames == null) {
            return null;
        }
        for (int i = 0; i < charsetNames.length; ++i) {
            Charset charset;
            if (!CodePageMapping.tryCharsetIsSupported(charsetNames[i]) || (charset = CodePageMapping.tryCharsetForName(charsetNames[i])) == null) continue;
            return charset;
        }
        if (!mustExist) {
            return null;
        }
        throw new UnknownCodePageException(codePage);
    }

    public static int getCodePage(String encoding) {
        return CodePageMapping.getCodePage(encoding, true);
    }

    public static int getCodePage(String encoding, boolean mustExist) {
        String name;
        Check.notNull(encoding, "encoding");
        Integer codePage = CodePageMapping.tryLookupSystemPropertyCodePage(encoding);
        if (codePage != null) {
            return codePage;
        }
        Charset charset = CodePageMapping.tryCharsetForName(encoding);
        if (charset != null) {
            name = charset.name();
            if (!encoding.equalsIgnoreCase(name) && (codePage = CodePageMapping.tryLookupSystemPropertyCodePage(name)) != null) {
                return codePage;
            }
            Set<String> aliases = charset.aliases();
            for (String alias : aliases) {
                if (encoding.equalsIgnoreCase(alias) || (codePage = CodePageMapping.tryLookupSystemPropertyCodePage(alias)) == null) continue;
                return codePage;
            }
        }
        if ((codePage = CodePageData.getCodePage(encoding)) != null) {
            return codePage;
        }
        if (charset != null && !encoding.equalsIgnoreCase(name = charset.name()) && (codePage = CodePageData.getCodePage(charset.name())) != null) {
            return codePage;
        }
        if (mustExist) {
            if (charset != null) {
                throw new UnknownEncodingException(charset);
            }
            throw new UnknownEncodingException(encoding);
        }
        return 0;
    }

    public static int getCodePage(Charset charset) {
        return CodePageMapping.getCodePage(charset, true);
    }

    public static int getCodePage(Charset charset, boolean mustExist) {
        Check.notNull(charset, "charset");
        Integer codePage = CodePageMapping.tryLookupSystemPropertyCodePage(charset.name());
        if (codePage != null) {
            return codePage;
        }
        Set<String> aliases = charset.aliases();
        for (String alias : aliases) {
            codePage = CodePageMapping.tryLookupSystemPropertyCodePage(alias);
            if (codePage == null) continue;
            return codePage;
        }
        codePage = CodePageData.getCodePage(charset.name());
        if (codePage != null) {
            return codePage;
        }
        if (mustExist) {
            throw new UnknownEncodingException(charset);
        }
        return 0;
    }

    private static String[] getCharsetNamesForCodePage(int codePage, boolean mustExist) {
        String[] configuredCharsetNames;
        int i;
        ArrayList<String> charsetNames = new ArrayList<String>();
        String systemPropertyName = "codePageMapping." + codePage;
        String systemPropertyValue = System.getProperty(systemPropertyName);
        if (systemPropertyValue != null) {
            String[] systemPropertyCharsetNames = systemPropertyValue.split(",");
            for (i = 0; i < systemPropertyCharsetNames.length; ++i) {
                String charsetName = systemPropertyCharsetNames[i].trim();
                if (charsetName.length() <= 0 || charsetNames.contains(charsetName)) continue;
                charsetNames.add(charsetName);
            }
        }
        if ((configuredCharsetNames = CodePageData.getCharsetNames(codePage)) != null) {
            for (i = 0; i < configuredCharsetNames.length; ++i) {
                if (charsetNames.contains(configuredCharsetNames[i])) continue;
                charsetNames.add(configuredCharsetNames[i]);
            }
        }
        if (charsetNames.size() == 0) {
            if (mustExist) {
                throw new UnknownCodePageException(codePage);
            }
            return null;
        }
        return charsetNames.toArray(new String[charsetNames.size()]);
    }

    private static Charset tryCharsetForName(String charsetName) {
        try {
            return Charset.forName(charsetName);
        }
        catch (IllegalCharsetNameException e) {
            return null;
        }
        catch (UnsupportedCharsetException e) {
            return null;
        }
    }

    private static boolean tryCharsetIsSupported(String charsetName) {
        try {
            return Charset.isSupported(charsetName);
        }
        catch (IllegalCharsetNameException e) {
            return false;
        }
    }

    private static Integer tryLookupSystemPropertyCodePage(String charsetName) {
        String value = System.getProperty("charsetMapping." + charsetName);
        if (value == null) {
            value = System.getProperty("charsetMapping." + charsetName.toLowerCase());
        }
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static class UnknownEncodingException
    extends TECoreException {
        private final Charset charset;
        private final String encoding;

        public UnknownEncodingException(Charset charset) {
            super(MessageFormat.format("The charset \"{0}\" is unknown", charset.name()));
            Check.notNull(charset, "charset");
            this.charset = charset;
            this.encoding = null;
        }

        public UnknownEncodingException(String encoding) {
            super(MessageFormat.format("The encoding \"{0}\" is unknown", encoding));
            Check.notNull(encoding, "encoding");
            this.charset = null;
            this.encoding = encoding;
        }

        public String getEncoding() {
            if (this.charset != null) {
                return this.charset.name();
            }
            return this.encoding;
        }

        public Charset getCharset() {
            return this.charset;
        }
    }

    public static class UnknownCodePageException
    extends TECoreException {
        private final int codePage;

        public UnknownCodePageException(int codePage) {
            super(MessageFormat.format("The code page {0} is unknown", Integer.toString(codePage)));
            this.codePage = codePage;
        }

        public int getCodePage() {
            return this.codePage;
        }
    }
}

