/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util.diffmerge;

import com.microsoft.tfs.core.externaltools.ExternalTool;
import com.microsoft.tfs.core.externaltools.formatters.MergeToolArgumentFormatter;
import com.microsoft.tfs.core.externaltools.validators.ExternalToolException;
import com.microsoft.tfs.core.util.diffmerge.ThreeWayMerge;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.process.ProcessFinishedHandler;
import com.microsoft.tfs.util.process.ProcessRunner;
import java.io.File;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExternalRunner {
    private static final Log log = LogFactory.getLog(ExternalRunner.class);

    public static ProcessRunner beginMerge(ThreeWayMerge twm, ExternalTool tool, ProcessFinishedHandler finishedHandler, OutputStream capturedStandardOutput, OutputStream capturedStandardError) throws ExternalToolException {
        Check.notNull(twm, "twm");
        Check.notNull(tool, "tool");
        Check.isTrue(new File(twm.getTheirFileName()).exists(), "Their file " + twm.getTheirFileName() + " must exist");
        Check.isTrue(new File(twm.getYourFileName()).exists(), "Your file " + twm.getYourFileName() + " must exist");
        Check.isTrue(!new File(twm.getMergedFileName()).exists(), "Merged output file " + twm.getMergedFileName() + " must not exist");
        log.info((Object)MessageFormat.format("Beginning external merge for {0}", twm.getYourFileName()));
        String[] arguments = new MergeToolArgumentFormatter().formatArguments(tool, twm.getTheirFileName(), twm.getYourFileName(), twm.getBaseFileName(), twm.getMergedFileName(), twm.getTheirFileLabel(), twm.getYourFileLabel(), twm.getBaseFileLabel(), twm.getMergedFileLabel());
        String[] fullCommandAndArguments = ExternalRunner.combineCommandAndArguments(tool.getCommand(), arguments);
        ProcessRunner mergeProcessRunner = new ProcessRunner(fullCommandAndArguments, null, null, finishedHandler, capturedStandardOutput, capturedStandardError);
        log.info((Object)MessageFormat.format("Running external merge tool like: {0}", mergeProcessRunner.getCommandLineForDisplay()));
        ProcessRunner.runAsync(mergeProcessRunner);
        log.info((Object)"External merge tool started");
        return mergeProcessRunner;
    }

    public static boolean endMerge(ProcessRunner mergeProcessRunner, String mergedFileName) {
        Check.notNull(mergedFileName, "mergedFileName");
        if (mergeProcessRunner == null) {
            return false;
        }
        File mergedFile = new File(mergedFileName);
        log.info((Object)"Waiting for external merge tool exit via waitForFinish()");
        mergeProcessRunner.waitForFinish();
        ProcessRunner.ProcessRunnerState state = mergeProcessRunner.getState();
        if (state == ProcessRunner.ProcessRunnerState.INTERRUPTED) {
            log.info((Object)"External merge tool runner state was INTERRUPTED");
            mergedFile.delete();
            return false;
        }
        if (state == ProcessRunner.ProcessRunnerState.EXEC_FAILED) {
            log.info((Object)"External merge tool runner state was EXEC_FAILED", mergeProcessRunner.getExecutionError());
            mergedFile.delete();
            return false;
        }
        Check.isTrue(state == ProcessRunner.ProcessRunnerState.COMPLETED, "Process runner returned unknown terminal state " + state.getClass().getName());
        int ret = mergeProcessRunner.getExitCode();
        log.info((Object)MessageFormat.format("External merge tool runner state was COMPLETED with exit code {0}", ret));
        if (ret != 0) {
            mergedFile.delete();
            return false;
        }
        if (!mergedFile.exists()) {
            log.warn((Object)MessageFormat.format("External merge tool didn't create an output file {0}; failed merge", mergedFileName));
            return false;
        }
        if (mergedFile.length() == 0L) {
            log.warn((Object)MessageFormat.format("External merge tool created an empty output file {0}, which isn't good enough; failed merge", mergedFileName));
            mergedFile.delete();
            return false;
        }
        log.info((Object)"External merge created good merge output file");
        return true;
    }

    public static String[] combineCommandAndArguments(String command, String[] arguments) {
        Check.notNull(command, "command");
        Check.notNull(arguments, "arguments");
        String[] fullCommandAndArguments = new String[arguments.length + 1];
        fullCommandAndArguments[0] = command;
        for (int i = 0; i < arguments.length; ++i) {
            fullCommandAndArguments[i + 1] = arguments[i];
        }
        return fullCommandAndArguments;
    }
}

