/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.ws.runtime.types;

import com.microsoft.tfs.core.ws.runtime.types.AnyContentType;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.xml.DOMCreateUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMAnyContentType
implements AnyContentType {
    private Element[] elements = new Element[0];

    public DOMAnyContentType() {
    }

    public DOMAnyContentType(Element[] elements) {
        this.setElements(elements);
    }

    public void setElements(Element[] elements) {
        Check.notNull(elements, "elements");
        this.elements = elements;
    }

    public Element[] getElements() {
        return this.elements;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DOMAnyContentType)) {
            return false;
        }
        return Arrays.equals(this.elements, ((DOMAnyContentType)obj).elements);
    }

    public int hashCode() {
        int ret = 1;
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] == null) continue;
            ret += this.elements[i].hashCode();
        }
        return ret;
    }

    @Override
    public void readFromElement(XMLStreamReader reader) throws XMLStreamException {
        this.elements = DOMAnyContentType.readElements(reader);
    }

    @Override
    public void writeAsElement(XMLStreamWriter writer, String name) throws XMLStreamException {
        writer.writeStartElement(name);
        DOMAnyContentType.writeElements(writer, this.elements);
        writer.writeEndElement();
    }

    @Override
    public Iterator getElementIterator() {
        return new ArrayList<Element>(Arrays.asList(this.elements)).iterator();
    }

    @Override
    public void dispose() {
        this.elements = new Element[0];
    }

    public static final Element[] readElements(XMLStreamReader reader) throws XMLStreamException {
        int event;
        ArrayList<Element> elements = new ArrayList<Element>();
        do {
            if ((event = reader.next()) != 1) continue;
            elements.add(DOMAnyContentType.readElement(reader));
        } while (event != 2);
        return elements.toArray(new Element[0]);
    }

    public static final Element readElement(XMLStreamReader reader) throws XMLStreamException {
        int event = reader.getEventType();
        Document document = null;
        Element currentElement = null;
        while (true) {
            if (event == 1) {
                if (document == null) {
                    document = DOMCreateUtils.newDocument(reader.getLocalName());
                    currentElement = document.getDocumentElement();
                } else {
                    Element newElement = document.createElement(reader.getLocalName());
                    currentElement.appendChild(newElement);
                    currentElement = newElement;
                }
                int attributeCount = reader.getAttributeCount();
                for (int i = 0; i < attributeCount; ++i) {
                    currentElement.setAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                }
            } else if (event == 2) {
                if (currentElement == document.getDocumentElement()) break;
                currentElement = (Element)currentElement.getParentNode();
            } else if (event == 4) {
                Text textNode = document.createTextNode(reader.getText());
                currentElement.appendChild(textNode);
            }
            event = reader.next();
        }
        return currentElement;
    }

    public static void writeElements(XMLStreamWriter writer, Element[] elements) throws XMLStreamException {
        for (int i = 0; i < elements.length; ++i) {
            DOMAnyContentType.writeElement(writer, elements[i]);
        }
    }

    public static void writeElement(XMLStreamWriter writer, Element element) throws XMLStreamException {
        if (element.getPrefix() != null) {
            writer.writeStartElement(element.getPrefix(), element.getLocalName(), element.getNamespaceURI());
            writer.writeNamespace(element.getPrefix(), element.getNamespaceURI());
        } else {
            boolean equalToCurrentNamspaceURI;
            String elementNamspaceUri = element.getNamespaceURI();
            String elementName = elementNamspaceUri == null ? element.getNodeName() : element.getLocalName();
            writer.writeStartElement(elementName);
            if (elementNamspaceUri != null && elementNamspaceUri.length() == 0) {
                elementNamspaceUri = null;
            }
            String currentNamespaceUri = writer.getNamespaceContext().getNamespaceURI("");
            boolean bl = elementNamspaceUri == null ? currentNamespaceUri == null : (equalToCurrentNamspaceURI = elementNamspaceUri.equals(currentNamespaceUri));
            if (!equalToCurrentNamspaceURI) {
                writer.writeDefaultNamespace(elementNamspaceUri);
                writer.setDefaultNamespace(elementNamspaceUri);
            }
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attributeNode = attributes.item(i);
            writer.writeAttribute(attributeNode.getNodeName(), attributeNode.getNodeValue());
        }
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String value;
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                DOMAnyContentType.writeElement(writer, (Element)child);
                continue;
            }
            if (child.getNodeType() == 3) {
                value = child.getNodeValue();
                if (value == null) {
                    value = "";
                }
                writer.writeCharacters(value);
                continue;
            }
            if (child.getNodeType() != 4) continue;
            value = child.getNodeValue();
            if (value == null) {
                value = "";
            }
            writer.writeCData(value);
        }
        writer.writeEndElement();
    }
}

