/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni;

import com.microsoft.tfs.jni.WinCredential;
import com.microsoft.tfs.jni.internal.wincredential.NativeWinCredential;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.StringUtil;

public class WinCredentialUtils {
    private static final WinCredentialUtils instance = new WinCredentialUtils();
    private final NativeWinCredential nativeImpl = new NativeWinCredential();

    public static WinCredentialUtils getInstance() {
        return instance;
    }

    private WinCredentialUtils() {
    }

    public boolean storeCredential(WinCredential credential) {
        Check.notNull(credential, "credential");
        return this.nativeImpl.storeCredential(credential);
    }

    public WinCredential findCredential(WinCredential credential) {
        Check.notNull(credential, "credential");
        if (StringUtil.isNullOrEmpty(credential.getServerUri())) {
            return null;
        }
        WinCredential winCredential = this.nativeImpl.findCredential(credential);
        if (winCredential == null) {
            return null;
        }
        return winCredential;
    }

    public boolean eraseCredential(WinCredential credential) {
        Check.notNull(credential, "credential");
        return this.nativeImpl.eraseCredential(credential);
    }
}

