/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.logging.config;

import com.microsoft.tfs.logging.config.LoggingConfigurationProvider;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;

public class ClassloaderConfigurationProvider
implements LoggingConfigurationProvider {
    private final ClassLoader classLoader;
    private final String[] resourceNames;

    public ClassloaderConfigurationProvider(ClassLoader classLoader, String[] resourceNames) {
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader must not be null");
        }
        if (resourceNames == null) {
            throw new IllegalArgumentException("resourceNames must not be null");
        }
        this.classLoader = classLoader;
        this.resourceNames = resourceNames;
    }

    @Override
    public URL getConfigurationURL() {
        URL url = null;
        for (int i = 0; i < this.resourceNames.length; ++i) {
            Enumeration<URL> availableResources = null;
            try {
                availableResources = this.classLoader.getResources(this.resourceNames[i]);
            }
            catch (IOException ex) {
                System.err.println("ERROR: " + ex.getMessage());
                ex.printStackTrace();
            }
            if (availableResources != null) {
                while (availableResources.hasMoreElements()) {
                    url = availableResources.nextElement();
                }
            }
            if (url != null) break;
        }
        return url;
    }
}

