/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.IOUtils;
import com.microsoft.tfs.util.tasks.CanceledException;
import com.microsoft.tfs.util.tasks.TaskMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;

public class HashUtils {
    public static final String ALGORITHM_MD2 = "MD2";
    public static final String ALGORITHM_MD5 = "MD5";
    public static final String ALGORITHM_SHA_1 = "SHA-1";
    public static final String ALGORITHM_SHA_256 = "SHA-256";
    public static final String ALGORITHM_SHA_384 = "SHA-384";
    public static final String ALGORITHM_SHA_512 = "SHA-512";

    public static boolean isAlgorithmAvailable(String algorithm) {
        Check.notNull(algorithm, "algorithm");
        try {
            MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
        return true;
    }

    public static boolean isProviderAvailable(String providerName) {
        Check.notNull(providerName, "providerName");
        return Security.getProvider(providerName) != null;
    }

    public static byte[] hashString(String input, String charsetName, String algorithm) throws UncheckedNoSuchAlgorithmException, UncheckedUnsupportedEncodingException {
        MessageDigest digester = HashUtils.getMessageDigestInstance(algorithm);
        return HashUtils.hashString(input, charsetName, digester);
    }

    public static byte[] hashString(String input, String charsetName, String algorithm, String providerName) throws UncheckedNoSuchAlgorithmException, UncheckedNoSuchProviderException, UncheckedUnsupportedEncodingException {
        MessageDigest digester = HashUtils.getMessageDigestInstance(algorithm, providerName);
        return HashUtils.hashString(input, charsetName, digester);
    }

    public static byte[] hashString(String input, String charsetName, String algorithm, Provider provider) throws UncheckedNoSuchAlgorithmException, UncheckedUnsupportedEncodingException {
        MessageDigest digester = HashUtils.getMessageDigestInstance(algorithm, provider);
        return HashUtils.hashString(input, charsetName, digester);
    }

    private static byte[] hashString(String input, String charsetName, MessageDigest digester) throws UncheckedUnsupportedEncodingException {
        byte[] bytes;
        Check.notNull(input, "input");
        if (charsetName == null) {
            bytes = input.getBytes();
        } else {
            try {
                bytes = input.getBytes(charsetName);
            }
            catch (UnsupportedEncodingException e) {
                throw new UncheckedUnsupportedEncodingException(charsetName, e);
            }
        }
        return HashUtils.hashBytes(bytes, digester);
    }

    public static byte[] hashBytes(byte[] input, String algorithm) throws UncheckedNoSuchAlgorithmException {
        MessageDigest digester = HashUtils.getMessageDigestInstance(algorithm);
        return HashUtils.hashBytes(input, digester);
    }

    public static byte[] hashBytes(byte[] input, String algorithm, String providerName) throws UncheckedNoSuchAlgorithmException, UncheckedNoSuchProviderException {
        MessageDigest digester = HashUtils.getMessageDigestInstance(algorithm, providerName);
        return HashUtils.hashBytes(input, digester);
    }

    public static byte[] hashBytes(byte[] input, String algorithm, Provider provider) {
        MessageDigest digester = HashUtils.getMessageDigestInstance(algorithm, provider);
        return HashUtils.hashBytes(input, digester);
    }

    private static byte[] hashBytes(byte[] input, MessageDigest digester) {
        Check.notNull(input, "input");
        return digester.digest(input);
    }

    public static byte[] hashFile(File file, String algorithm) throws FileNotFoundException, FileNotFoundException, IOException, UncheckedNoSuchAlgorithmException {
        return HashUtils.hashFile(file, algorithm, (TaskMonitor)null);
    }

    public static byte[] hashFile(File file, String algorithm, TaskMonitor taskMonitor) throws FileNotFoundException, CanceledException, FileNotFoundException, IOException, UncheckedNoSuchAlgorithmException {
        MessageDigest digester = HashUtils.getMessageDigestInstance(algorithm);
        return HashUtils.hashFile(file, digester, taskMonitor);
    }

    public static byte[] hashFile(File file, String algorithm, String providerName) throws FileNotFoundException, IOException, UncheckedNoSuchAlgorithmException, UncheckedNoSuchProviderException {
        return HashUtils.hashFile(file, algorithm, providerName, (TaskMonitor)null);
    }

    public static byte[] hashFile(File file, String algorithm, String providerName, TaskMonitor taskMonitor) throws FileNotFoundException, IOException, UncheckedNoSuchAlgorithmException, UncheckedNoSuchProviderException, CanceledException {
        MessageDigest digester = HashUtils.getMessageDigestInstance(algorithm, providerName);
        return HashUtils.hashFile(file, digester, taskMonitor);
    }

    public static byte[] hashFile(File file, String algorithm, Provider provider) throws FileNotFoundException, IOException, UncheckedNoSuchAlgorithmException {
        return HashUtils.hashFile(file, algorithm, provider, (TaskMonitor)null);
    }

    public static byte[] hashFile(File file, String algorithm, Provider provider, TaskMonitor taskMonitor) throws FileNotFoundException, IOException, UncheckedNoSuchAlgorithmException, CanceledException {
        MessageDigest digester = HashUtils.getMessageDigestInstance(algorithm, provider);
        return HashUtils.hashFile(file, digester, taskMonitor);
    }

    private static byte[] hashFile(File file, MessageDigest digester, TaskMonitor taskMonitor) throws CanceledException, FileNotFoundException, IOException {
        Check.notNull(file, "file");
        FileInputStream stream = new FileInputStream(file);
        return HashUtils.hashStream((InputStream)stream, digester, taskMonitor);
    }

    public static byte[] hashStream(InputStream stream, String algorithm) throws IOException, UncheckedNoSuchAlgorithmException {
        return HashUtils.hashStream(stream, algorithm, (TaskMonitor)null);
    }

    public static byte[] hashStream(InputStream stream, String algorithm, TaskMonitor taskMonitor) throws IOException, UncheckedNoSuchAlgorithmException, CanceledException {
        MessageDigest digester = HashUtils.getMessageDigestInstance(algorithm);
        return HashUtils.hashStream(stream, digester, taskMonitor);
    }

    public static byte[] hashStream(InputStream stream, String algorithm, String providerName) throws IOException, UncheckedNoSuchAlgorithmException, UncheckedNoSuchProviderException {
        return HashUtils.hashStream(stream, algorithm, providerName, (TaskMonitor)null);
    }

    public static byte[] hashStream(InputStream stream, String algorithm, String providerName, TaskMonitor taskMonitor) throws IOException, UncheckedNoSuchAlgorithmException, UncheckedNoSuchProviderException, CanceledException {
        MessageDigest digester = HashUtils.getMessageDigestInstance(algorithm, providerName);
        return HashUtils.hashStream(stream, digester, taskMonitor);
    }

    public static byte[] hashStream(InputStream stream, String algorithm, Provider provider) throws IOException, UncheckedNoSuchAlgorithmException {
        return HashUtils.hashStream(stream, algorithm, provider, (TaskMonitor)null);
    }

    public static byte[] hashStream(InputStream stream, String algorithm, Provider provider, TaskMonitor taskMonitor) throws IOException, UncheckedNoSuchAlgorithmException, CanceledException {
        MessageDigest digester = HashUtils.getMessageDigestInstance(algorithm, provider);
        return HashUtils.hashStream(stream, digester, taskMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] hashStream(InputStream stream, MessageDigest digester, TaskMonitor taskMonitor) throws IOException, CanceledException {
        Check.notNull(stream, "stream");
        byte[] buffer = new byte[65536];
        int read = 0;
        try {
            if (taskMonitor != null && taskMonitor.isCanceled()) {
                throw new CanceledException();
            }
            while ((read = stream.read(buffer)) != -1) {
                if (taskMonitor != null && taskMonitor.isCanceled()) {
                    throw new CanceledException();
                }
                digester.update(buffer, 0, read);
            }
            byte[] byArray = digester.digest();
            return byArray;
        }
        finally {
            IOUtils.closeSafely(stream);
        }
    }

    private static MessageDigest getMessageDigestInstance(String algorithm, Provider provider) throws UncheckedNoSuchAlgorithmException {
        Check.notNull(algorithm, "algorithm");
        Check.notNull(provider, "provider");
        try {
            return MessageDigest.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UncheckedNoSuchAlgorithmException(algorithm, e);
        }
    }

    private static MessageDigest getMessageDigestInstance(String algorithm, String providerName) throws UncheckedNoSuchAlgorithmException, UncheckedNoSuchProviderException {
        Check.notNull(algorithm, "algorithm");
        Check.notNull(providerName, "providerName");
        try {
            return MessageDigest.getInstance(algorithm, providerName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UncheckedNoSuchAlgorithmException(algorithm, e);
        }
        catch (NoSuchProviderException e) {
            throw new UncheckedNoSuchProviderException(providerName, e);
        }
    }

    private static MessageDigest getMessageDigestInstance(String algorithm) throws UncheckedNoSuchAlgorithmException {
        Check.notNull(algorithm, "algorithm");
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UncheckedNoSuchAlgorithmException(algorithm, e);
        }
    }

    public static class UncheckedNoSuchProviderException
    extends RuntimeException {
        public UncheckedNoSuchProviderException(String providerName, NoSuchProviderException cause) {
            super("no such provider: [" + providerName + "]", cause);
        }
    }

    public static class UncheckedNoSuchAlgorithmException
    extends RuntimeException {
        public UncheckedNoSuchAlgorithmException(String algorithm, NoSuchAlgorithmException cause) {
            super("no such algorithm: [" + algorithm + "]", cause);
        }
    }

    public static class UncheckedUnsupportedEncodingException
    extends RuntimeException {
        public UncheckedUnsupportedEncodingException(String encoding, UnsupportedEncodingException cause) {
            super("unsupported encoding: [" + encoding + "]", cause);
        }
    }
}

