/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.datetime;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DotNETDate {
    public static final Calendar MIN_CALENDAR = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    public static final Calendar MIN_CALENDAR_LOCAL;
    public static final Calendar MAX_CALENDAR;
    public static final Calendar MAX_CALENDAR_LOCAL;
    private static final long JAVA_EPOCH_TICKS = 621355968000000000L;
    private static final long WIN_FS_EPOCH_TICKS = 116444736000000000L;
    private static final long DATETIME_BINARY_FLAG_UTC = 0x4000000000000000L;
    private static final long DATETIME_BINARY_FLAG_LOCAL = Long.MIN_VALUE;

    private DotNETDate() {
    }

    public static long toTicks(Calendar value) {
        return value.getTimeInMillis() * 10000L + 621355968000000000L;
    }

    public static long toWindowsFileTimeUTC(Calendar value) {
        return value.getTimeInMillis() * 10000L + 116444736000000000L;
    }

    public static Calendar fromTicks(long ticks) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis((ticks - 621355968000000000L) / 10000L);
        return calendar;
    }

    public static Calendar fromWindowsFileTimeUTC(long ticks) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis((ticks - 116444736000000000L) / 10000L);
        return calendar;
    }

    public static Calendar fromBinary(long value) {
        if ((value & Long.MIN_VALUE) == Long.MIN_VALUE) {
            throw new IllegalArgumentException("Local-form DateTime serializations are not parseable");
        }
        Calendar calendar = DotNETDate.fromTicks(value & 0xBFFFFFFFFFFFFFFFL);
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        return calendar;
    }

    public static long toBinary(Calendar value) {
        return DotNETDate.toTicks(value) | 0x4000000000000000L;
    }

    static {
        MIN_CALENDAR.setTime(new Date(-62135769600000L));
        MIN_CALENDAR_LOCAL = Calendar.getInstance();
        MIN_CALENDAR_LOCAL.setTime(new Date(-62135769600000L));
        MAX_CALENDAR = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        MAX_CALENDAR.set(9999, 11, 31, 23, 59, 59);
        MAX_CALENDAR.set(14, 999);
        MAX_CALENDAR_LOCAL = Calendar.getInstance();
        MAX_CALENDAR.set(9999, 11, 31, 23, 59, 59);
        MAX_CALENDAR.set(14, 999);
    }
}

