/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.temp;

import com.microsoft.tfs.util.StringUtil;
import com.microsoft.tfs.util.temp.TempStorageService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FastTempOutputStream
extends OutputStream {
    private static final Log log = LogFactory.getLog(FastTempOutputStream.class);
    public static final int DEFAULT_HEAP_STORAGE_INITIAL_SIZE_BYTES = 8192;
    public static final int DEFAULT_HEAP_STORAGE_LIMIT_BYTES = FastTempOutputStream.getDefaultHeapStorageLimit();
    private final int heapStorageLimitBytes;
    private DirectAccessByteArrayOutputStream heapStream;
    private OutputStream fileStream;
    private File file;
    private OutputStream currentStream;
    private boolean writable = true;

    public FastTempOutputStream() {
        this(DEFAULT_HEAP_STORAGE_LIMIT_BYTES, 8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FastTempOutputStream(int heapStorageLimitBytes, int initialHeapStorageSizeBytes) {
        if (heapStorageLimitBytes < 0) {
            heapStorageLimitBytes = DEFAULT_HEAP_STORAGE_LIMIT_BYTES;
        }
        if (initialHeapStorageSizeBytes < 0) {
            initialHeapStorageSizeBytes = 8192;
        }
        String messageFormat = "New instance with heap limit of {0} bytes, initial heap size {1}";
        String message = MessageFormat.format("New instance with heap limit of {0} bytes, initial heap size {1}", heapStorageLimitBytes, initialHeapStorageSizeBytes);
        log.trace((Object)message);
        FastTempOutputStream fastTempOutputStream = this;
        synchronized (fastTempOutputStream) {
            this.heapStorageLimitBytes = heapStorageLimitBytes;
            this.heapStream = new DirectAccessByteArrayOutputStream(initialHeapStorageSizeBytes);
            this.currentStream = this.heapStream;
        }
    }

    private static int getDefaultHeapStorageLimit() {
        String propertyName = "com.microsoft.tfs.fasttempstream.heaplimit";
        String value = System.getProperty("com.microsoft.tfs.fasttempstream.heaplimit");
        if (!StringUtil.isNullOrEmpty(value)) {
            try {
                return StringUtil.toInt(value);
            }
            catch (NumberFormatException e) {
                String message = MessageFormat.format("Incorrect value of the system property {0} = {1}", "com.microsoft.tfs.fasttempstream.heaplimit", value);
                log.error((Object)message, (Throwable)e);
            }
        }
        return 0x800000;
    }

    private synchronized void adjustStorage(int increase) {
        if (increase <= 0 || this.fileStream != null) {
            return;
        }
        if (this.heapStream != null && this.heapStream.size() + increase > this.heapStorageLimitBytes) {
            String messageFormat = "adjustment for {0} total bytes (increase of {1}) exceeds threshold of {2}, switching to file storage";
            String message = MessageFormat.format(messageFormat, this.heapStream.size() + increase, increase, this.heapStorageLimitBytes);
            log.trace((Object)message);
            try {
                this.file = TempStorageService.getInstance().createTempFile();
                messageFormat = "Created temporary file {0} (exceeded heap limit of {1} bytes)";
                message = MessageFormat.format(messageFormat, this.file.getAbsolutePath(), this.heapStorageLimitBytes);
                log.debug((Object)message);
                this.fileStream = new BufferedOutputStream(new FileOutputStream(this.file), 16384);
            }
            catch (IOException e) {
                log.error((Object)"Error creating temp file", (Throwable)e);
                if (this.file != null) {
                    this.file.delete();
                }
                throw new RuntimeException(e);
            }
            try {
                messageFormat = "Copying {0} initial bytes from heap to file";
                message = MessageFormat.format(messageFormat, this.heapStream.size());
                log.trace((Object)message);
                this.heapStream.writeTo(this.fileStream);
            }
            catch (IOException e) {
                log.error((Object)"Error copying initial bytes", (Throwable)e);
                if (this.file != null) {
                    this.file.delete();
                }
                throw new RuntimeException(e);
            }
            this.heapStream = null;
            this.currentStream = this.fileStream;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.currentStream.close();
        this.writable = false;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.checkWritable();
        this.currentStream.flush();
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.checkWritable();
        this.adjustStorage(len);
        this.currentStream.write(b, off, len);
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.checkWritable();
        this.adjustStorage(b.length);
        this.currentStream.write(b);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.checkWritable();
        this.adjustStorage(1);
        this.currentStream.write(b);
    }

    private synchronized void checkWritable() throws IOException {
        if (!this.writable) {
            throw new IOException("The stream has been closed");
        }
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.writable) {
            throw new IOException("Cannot get an InputStream because the stream is still open for writing (call close())");
        }
        if (this.heapStream != null) {
            log.trace((Object)"Creating new ByteArrayInputStream");
            return new ByteArrayInputStream(this.heapStream.getByteArray(), 0, this.heapStream.size());
        }
        String messageFormat = "Creating new FileInputStream for {0}";
        String message = MessageFormat.format("Creating new FileInputStream for {0}", this.file.getAbsolutePath());
        log.trace((Object)message);
        return new BufferedInputStream(new FileInputStream(this.file), 16384);
    }

    public synchronized void dispose() throws IOException {
        log.trace((Object)"Disposing");
        this.close();
        if (this.heapStream != null) {
            this.heapStream = null;
        }
        if (this.fileStream != null) {
            this.fileStream = null;
        }
        if (this.file != null) {
            TempStorageService.getInstance().cleanUpItem(this.file);
            String messageFormat = "Deleted file storage {0}";
            String message = MessageFormat.format("Deleted file storage {0}", this.file.getAbsolutePath());
            log.debug((Object)message);
            this.file = null;
        }
    }

    private static class DirectAccessByteArrayOutputStream
    extends ByteArrayOutputStream {
        public DirectAccessByteArrayOutputStream(int size) {
            super(size);
        }

        protected byte[] getByteArray() {
            return this.buf;
        }
    }
}

