/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.thread;

import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadInterruptTimer
extends Thread {
    private static final Log log = LogFactory.getLog(ThreadInterruptTimer.class);
    public static final int TIMEOUT_CHECK_PERIOD_SECONDS = 2;
    private long lastReset;
    private int interruptTimeoutSeconds;
    final Thread threadToInterrupt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadInterruptTimer(int interruptTimeoutSeconds, Thread threadToInterrupt) {
        super("Thread Interrupt Timer");
        Check.isTrue(interruptTimeoutSeconds > 0, "interruptTimoutSeconds must be positive");
        Check.notNull(threadToInterrupt, "threadToInterrupt");
        ThreadInterruptTimer threadInterruptTimer = this;
        synchronized (threadInterruptTimer) {
            this.interruptTimeoutSeconds = interruptTimeoutSeconds;
            this.threadToInterrupt = threadToInterrupt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        long now = System.currentTimeMillis();
        String messageFormat = "Resetting idle at {0}";
        String message = MessageFormat.format("Resetting idle at {0}", now);
        log.trace((Object)message);
        ThreadInterruptTimer threadInterruptTimer = this;
        synchronized (threadInterruptTimer) {
            this.lastReset = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread interruptThisThread;
        this.reset();
        while (true) {
            long interruptTimeoutSecondsCopy;
            long lastResetCopy;
            ThreadInterruptTimer threadInterruptTimer = this;
            synchronized (threadInterruptTimer) {
                lastResetCopy = this.lastReset;
                interruptTimeoutSecondsCopy = this.interruptTimeoutSeconds;
            }
            long idleMilliseconds = System.currentTimeMillis() - lastResetCopy;
            if (idleMilliseconds > interruptTimeoutSecondsCopy * 1000L) break;
            String messageFormat = "Idle for an acceptable {0} milliseconds out of {1}";
            String message = MessageFormat.format("Idle for an acceptable {0} milliseconds out of {1}", idleMilliseconds, interruptTimeoutSecondsCopy * 1000L);
            log.trace((Object)message);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        ThreadInterruptTimer threadInterruptTimer = this;
        synchronized (threadInterruptTimer) {
            interruptThisThread = this.threadToInterrupt;
        }
        String messageFormat = "Timeout period of {0} seconds exceeded, interrupting {1}";
        String message = MessageFormat.format("Timeout period of {0} seconds exceeded, interrupting {1}", this.interruptTimeoutSeconds, interruptThisThread.toString());
        log.debug((Object)message);
        interruptThisThread.interrupt();
    }
}

