/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.algo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

public class MaxWeightMatching<N1, N2> {
    private boolean swapped;
    private int size1;
    private int size2;
    private List<N1> nodes1;
    private List<N2> nodes2;
    private IWeightProvider<N1, N2> weightProvider;
    private Double[][] weightCache;
    private int[] mate = new int[16];
    private int[] from = new int[16];
    private double[] dist = new double[16];

    public double calculateMatching(List<N1> nodes1, List<N2> nodes2, IWeightProvider<N1, N2> weightProvider, PairList<N1, N2> matching) {
        if (matching != null) {
            matching.clear();
        }
        if (nodes1.isEmpty() || nodes2.isEmpty()) {
            return 0.0;
        }
        this.init(nodes1, nodes2, weightProvider);
        this.prepareInternalArrays();
        for (int i = 0; i < this.size1; ++i) {
            this.augmentFrom(i);
        }
        double res = 0.0;
        for (int i = 0; i < this.size2; ++i) {
            if (this.mate[i] < 0) continue;
            if (matching != null) {
                if (this.swapped) {
                    matching.add(nodes1.get(i), nodes2.get(this.mate[i]));
                } else {
                    matching.add(nodes1.get(this.mate[i]), nodes2.get(i));
                }
            }
            res += this.getWeight(this.mate[i], i);
        }
        return res;
    }

    public double greedyMatch(PairList<N1, N2> matching) {
        ArrayList<Pair> allPairs = new ArrayList<Pair>();
        for (int i = 0; i < this.nodes1.size(); ++i) {
            for (int j = 0; j < this.nodes2.size(); ++j) {
                allPairs.add(Pair.createPair(i, j));
            }
        }
        allPairs.sort(Comparator.comparingDouble(pair -> this.getWeight((Integer)pair.getFirst(), (Integer)pair.getSecond(), false)).reversed());
        double weight = 0.0;
        boolean[] seen1 = new boolean[this.nodes1.size()];
        boolean[] seen2 = new boolean[this.nodes2.size()];
        for (Pair pair2 : allPairs) {
            if (seen1[(Integer)pair2.getFirst()] || seen2[(Integer)pair2.getSecond()]) continue;
            seen1[((Integer)pair2.getFirst()).intValue()] = true;
            seen2[((Integer)pair2.getSecond()).intValue()] = true;
            weight += this.getWeight((Integer)pair2.getFirst(), (Integer)pair2.getSecond(), false);
            if (matching == null) continue;
            matching.add(this.nodes1.get((Integer)pair2.getFirst()), this.nodes2.get((Integer)pair2.getSecond()));
        }
        return weight;
    }

    private void init(List<N1> nodes1, List<N2> nodes2, IWeightProvider<N1, N2> weightProvider) {
        if (nodes1.size() <= nodes2.size()) {
            this.size1 = nodes1.size();
            this.size2 = nodes2.size();
            this.swapped = false;
        } else {
            this.size1 = nodes2.size();
            this.size2 = nodes1.size();
            this.swapped = true;
        }
        this.nodes1 = nodes1;
        this.nodes2 = nodes2;
        this.weightProvider = weightProvider;
        this.weightCache = new Double[nodes1.size()][nodes2.size()];
    }

    private void prepareInternalArrays() {
        if (this.size2 > this.mate.length) {
            int newSize;
            for (newSize = this.mate.length; newSize < this.size2; newSize *= 2) {
            }
            this.mate = new int[newSize];
            this.from = new int[newSize];
            this.dist = new double[newSize];
        }
        Arrays.fill(this.mate, 0, this.size2, -1);
    }

    private void augmentFrom(int u) {
        for (int i = 0; i < this.size2; ++i) {
            this.from[i] = -1;
            this.dist[i] = this.getWeight(u, i);
        }
        this.bellmanFord();
        int target = this.findBestUnmatchedTarget();
        this.augmentAlongPath(u, target);
    }

    private void bellmanFord() {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = 0; i < this.size2; ++i) {
                if (this.mate[i] < 0) continue;
                double w = this.getWeight(this.mate[i], i);
                for (int j = 0; j < this.size2; ++j) {
                    double newDist;
                    if (i == j || !((newDist = this.dist[i] - w + this.getWeight(this.mate[i], j)) - 1.0E-15 > this.dist[j])) continue;
                    this.dist[j] = newDist;
                    this.from[j] = i;
                    changed = true;
                }
            }
            this.updateProgressTick();
        }
    }

    protected void updateProgressTick() {
    }

    private int findBestUnmatchedTarget() {
        int target = -1;
        for (int i = 0; i < this.size2; ++i) {
            if (this.mate[i] >= 0 || target >= 0 && !(this.dist[i] > this.dist[target])) continue;
            target = i;
        }
        return target;
    }

    private void augmentAlongPath(int u, int target) {
        while (this.from[target] >= 0) {
            this.mate[target] = this.mate[this.from[target]];
            target = this.from[target];
        }
        this.mate[target] = u;
    }

    private double getWeight(int i1, int i2) {
        return this.getWeight(i1, i2, true);
    }

    private double getWeight(int i1, int i2, boolean swapAware) {
        Double result;
        int k1 = i1;
        int k2 = i2;
        if (swapAware && this.swapped) {
            k1 = i2;
            k2 = i1;
        }
        if ((result = this.weightCache[k1][k2]) == null) {
            this.weightCache[k1][k2] = result = Double.valueOf(this.weightProvider.getConnectionWeight(this.nodes1.get(k1), this.nodes2.get(k2)));
        }
        return result;
    }

    public static interface IWeightProvider<N1, N2> {
        public double getConnectionWeight(N1 var1, N2 var2);
    }
}

