/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;

public class CounterSetSorting {
    public static Comparator<CounterSet<Object>> comparator(Object[] allKeyCandidatesOrdered, Object[][] sortOrder) {
        int[][] sortOrderIndices = new int[sortOrder.length][];
        for (int i = 0; i < sortOrder.length; ++i) {
            sortOrderIndices[i] = CounterSetSorting.keysToKeyIndicies(allKeyCandidatesOrdered, sortOrder[i]);
        }
        return CounterSetSorting.comparator(allKeyCandidatesOrdered, sortOrderIndices);
    }

    public static <E> Comparator<CounterSet<E>> comparator(E[] allKeyCandidatesOrdered, int[][] sortOrder) {
        return (set1, set2) -> {
            boolean secondIsEmpty;
            boolean firstIsEmpty = set1 == null || set1.getKeys().isEmpty();
            boolean bl = secondIsEmpty = set2 == null || set2.getKeys().isEmpty();
            if (firstIsEmpty && !secondIsEmpty) {
                return -1;
            }
            if (!firstIsEmpty && secondIsEmpty) {
                return 1;
            }
            if (firstIsEmpty && secondIsEmpty) {
                return 0;
            }
            Pair<double[], Long> percentages1 = CounterSetSorting.toPercentages(set1.transformToList(allKeyCandidatesOrdered));
            Pair<double[], Long> percentages2 = CounterSetSorting.toPercentages(set2.transformToList(allKeyCandidatesOrdered));
            if ((Long)percentages1.getSecond() == 0L || (Long)percentages2.getSecond() == 0L) {
                return Math.round((Long)percentages1.getSecond() - (Long)percentages2.getSecond());
            }
            return CounterSetSorting.compareSeverities((double[])percentages1.getFirst(), (double[])percentages2.getFirst(), sortOrder);
        };
    }

    private static int[] keysToKeyIndicies(Object[] orderedKeys, Object[] returnIndicesOf) {
        int[] result = new int[returnIndicesOf.length];
        for (int i = 0; i < returnIndicesOf.length; ++i) {
            Object indexOf = returnIndicesOf[i];
            boolean found = false;
            for (int keyIndex = 0; keyIndex < orderedKeys.length; ++keyIndex) {
                if (!orderedKeys[keyIndex].equals(indexOf)) continue;
                result[i] = keyIndex;
                found = true;
            }
            if (found) continue;
            throw new IllegalArgumentException(String.format("Was not able to lookup key index for %s", indexOf));
        }
        return result;
    }

    private static Pair<double[], Long> toPercentages(int[] list) {
        long sum = Arrays.stream(list).sum();
        double[] result = new double[list.length];
        for (int i = 0; i < list.length; ++i) {
            int element = list[i];
            result[i] = sum == 0L ? Double.NaN : (double)element / (double)sum;
        }
        return Pair.createPair(result, sum);
    }

    private static int compareSeverities(double[] lhs, double[] rhs, int[][] sortOrder) {
        List<double[]> groupedLhs = CounterSetSorting.accumulateByGroup(lhs, sortOrder);
        List<double[]> groupedRhs = CounterSetSorting.accumulateByGroup(rhs, sortOrder);
        return CounterSetSorting.compare3(groupedLhs, groupedRhs);
    }

    private static List<double[]> accumulateByGroup(double[] inputArray, int[][] sortOrders) {
        ArrayList<double[]> result = new ArrayList<double[]>();
        for (int[] subSortOrder : sortOrders) {
            double[] permutedArray = CounterSetSorting.copyByIndex(inputArray, subSortOrder);
            result.add(CounterSetSorting.accumulateLeft(permutedArray));
        }
        return result;
    }

    private static double[] accumulateLeft(double[] array) {
        double[] result = new double[array.length];
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            result[array.length - i - 1] = sum += array[i];
        }
        return result;
    }

    private static double[] copyByIndex(double[] inputArray, int[] sortOrder) {
        double[] result = new double[sortOrder.length];
        for (int i = 0; i < sortOrder.length; ++i) {
            result[i] = inputArray[sortOrder[i]];
        }
        return result;
    }

    private static int compare3(List<double[]> list1, List<double[]> list2) {
        for (int i = 0; i < Math.min(list1.size(), list2.size()); ++i) {
            int comparisonResult = CounterSetSorting.compareArrays(list1.get(i), list2.get(i));
            if (comparisonResult == 0) continue;
            return comparisonResult;
        }
        return Integer.compare(list1.size(), list2.size());
    }

    private static int compareArrays(double[] arr1, double[] arr2) {
        for (int i = 0; i < Math.min(arr1.length, arr2.length); ++i) {
            int comparisonResult = Double.compare(arr1[i], arr2[i]);
            if (comparisonResult == 0) continue;
            return comparisonResult;
        }
        return Integer.compare(arr1.length, arr2.length);
    }
}

