/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class ImmutablePair<S, T>
implements Cloneable,
Comparable<ImmutablePair<S, T>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String FIRST_PROPERTY = "first";
    protected static final String SECOND_PROPERTY = "second";
    @JsonProperty(value="first")
    protected S first;
    @JsonProperty(value="second")
    protected T second;

    @JsonCreator
    public ImmutablePair(@JsonProperty(value="first") S first, @JsonProperty(value="second") T second) {
        this.first = first;
        this.second = second;
    }

    public ImmutablePair(ImmutablePair<S, T> p) {
        this.first = p.first;
        this.second = p.second;
    }

    public S getFirst() {
        return this.first;
    }

    public T getSecond() {
        return this.second;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ImmutablePair)) {
            return false;
        }
        ImmutablePair p = (ImmutablePair)obj;
        return ImmutablePair.areEqual(this.first, p.first) && ImmutablePair.areEqual(this.second, p.second);
    }

    private static boolean areEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public int hashCode() {
        int firstCode = 1;
        if (this.first != null) {
            firstCode = this.first.hashCode();
        }
        int secondCode = 1;
        if (this.second != null) {
            secondCode = this.second.hashCode();
        }
        return firstCode + 1013 * secondCode;
    }

    public String toString() {
        return "(" + String.valueOf(this.first) + "," + String.valueOf(this.second) + ")";
    }

    protected ImmutablePair<S, T> clone() {
        return new ImmutablePair<S, T>(this);
    }

    @Override
    public int compareTo(ImmutablePair<S, T> pair) {
        int cmp = ImmutablePair.objCompare(this.first, pair.first);
        if (cmp != 0) {
            return cmp;
        }
        return ImmutablePair.objCompare(this.second, pair.second);
    }

    private static <O> int objCompare(O o1, O o2) {
        int h2;
        int h1;
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            try {
                return ((Comparable)o1).compareTo(o2);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if ((h1 = o1.hashCode()) == (h2 = o2.hashCode())) {
            return 0;
        }
        if (h1 < h2) {
            return -1;
        }
        return 1;
    }
}

