/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;

public abstract class MapBackedSetBase<E>
extends AbstractSet<E> {
    private static final Object PRESENT = new Object();
    private final Map<E, Object> map;

    protected MapBackedSetBase(Map<E, Object> map) {
        this.map = map;
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, PRESENT) == null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

