/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Stream;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.NonNull;

public class SynchronizedPairList<S, T>
implements Iterable<Pair<S, T>> {
    private final PairList<S, T> delegate;
    private final Object mutex;

    public SynchronizedPairList() {
        this.delegate = new PairList();
        this.mutex = this;
    }

    public SynchronizedPairList(PairList<S, T> delegate) {
        this.delegate = delegate;
        this.mutex = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.mutex;
        synchronized (object) {
            return this.delegate.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.mutex;
        synchronized (object) {
            return this.delegate.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(S first, T second) {
        Object object = this.mutex;
        synchronized (object) {
            this.delegate.add(first, second);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Pair<S, T> pair) {
        Object object = this.mutex;
        synchronized (object) {
            this.delegate.add(pair);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int index, S first, T second) {
        Object object = this.mutex;
        synchronized (object) {
            this.delegate.insert(index, first, second);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(PairList<S, T> other) {
        Object object = this.mutex;
        synchronized (object) {
            this.delegate.addAll(other);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(S firstElement, Iterable<T> secondElements) {
        Object object = this.mutex;
        synchronized (object) {
            this.delegate.addAll(firstElement, secondElements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mutex;
        synchronized (object) {
            this.delegate.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int index) {
        Object object = this.mutex;
        synchronized (object) {
            this.delegate.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mutex;
        synchronized (object) {
            return this.delegate.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.mutex;
        synchronized (object) {
            return this.delegate.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        Object object = this.mutex;
        synchronized (object) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof SynchronizedPairList) {
                SynchronizedPairList other = (SynchronizedPairList)obj;
                return this.delegate.equals(other.delegate);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull Iterator<Pair<S, T>> iterator() {
        Object object = this.mutex;
        synchronized (object) {
            return new ArrayList<Pair<S, T>>(this.delegate.toList()).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<Pair<S, T>> stream() {
        Object object = this.mutex;
        synchronized (object) {
            return new ArrayList<Pair<S, T>>(this.delegate.toList()).stream();
        }
    }
}

