/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.filesystem;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Stream;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class TemporaryDirectory
implements AutoCloseable {
    private final Path path;
    private final boolean keepUntilShutdown;

    TemporaryDirectory(Path path, boolean keepUntilShutdown) throws IOException {
        this.path = path;
        this.keepUntilShutdown = keepUntilShutdown;
        FileSystemUtils.ensureDirectoryExists(path);
        if (keepUntilShutdown) {
            TemporaryDirectory.deleteOnShutdown(path);
        }
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public void close() throws IOException {
        if (this.keepUntilShutdown) {
            return;
        }
        TemporaryDirectory.delete(this.path);
    }

    private static void deleteOnShutdown(Path path) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                TemporaryDirectory.delete(path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }));
    }

    private static void delete(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            FileSystemUtils.deleteRecursively(path);
        } else {
            Files.delete(path);
        }
    }

    public void clear() throws IOException {
        try (Stream<Path> walk = Files.walk(this.path, new FileVisitOption[0]);){
            Iterator it = walk.sorted(Collections.reverseOrder()).iterator();
            while (it.hasNext()) {
                Files.delete((Path)it.next());
            }
        }
    }

    public String toString() {
        return this.path.toString();
    }
}

