/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot;

import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotCreationIndex;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotDto;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotMetaData;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.conqat.engine.core.stream.IStreamWithException;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@Index(name="instance-comparison-external-snapshots", options={EStorageOption.COMPRESSED}, valueClasses={InstanceComparisonSnapshotMetaData.class})
public class InstanceComparisonExternalSnapshotIndex
implements IGlobalIndex {
    public static final String NAME = "instance-comparison-external-snapshots";
    private final ValueIndex<InstanceComparisonExternalSnapshotMetaData> metaDataIndex;
    private final InstanceComparisonSnapshotCreationIndex snapshotIndex;

    public InstanceComparisonExternalSnapshotIndex(IStore store) {
        this.metaDataIndex = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, "metadata"));
        this.snapshotIndex = new InstanceComparisonSnapshotCreationIndex((IStore)new DelegatingPartitionStore(store, "snapshots"));
    }

    public void storeSnapshot(String name, String uploadUser, InstanceComparisonSnapshotDto snapshot) throws StorageException {
        CCSMAssert.isNotNull((Object)name, () -> String.format("Expected \"%s\" to be not null", "name"));
        CCSMAssert.isNotNull((Object)uploadUser, () -> String.format("Expected \"%s\" to be not null", "uploadUser"));
        CCSMAssert.isNotNull((Object)snapshot, () -> String.format("Expected \"%s\" to be not null", "snapshot"));
        if (this.getMetaData(name).isPresent()) {
            throw new IllegalStateException("There already exists a snapshot with name: " + name);
        }
        InstanceComparisonSnapshotMetaData snapshotMetaData = new InstanceComparisonSnapshotMetaData(snapshot);
        InstanceComparisonExternalSnapshotMetaData externalSnapshotMetaData = new InstanceComparisonExternalSnapshotMetaData(name, uploadUser, Instant.now(), snapshotMetaData);
        this.metaDataIndex.setValue(name, (Object)externalSnapshotMetaData);
        IStreamWithException.wrap(Stream.concat(snapshot.globalComparisonInputs().stream(), snapshot.projectComparisonInputs().stream())).withException(StorageException.class).forEach(contribution -> this.snapshotIndex.storeSnapshotContribution(snapshot.id(), (InstanceComparisonContributionBase)contribution));
    }

    public Optional<InstanceComparisonSnapshotDto> getSnapshot(String name) throws StorageException {
        Optional<InstanceComparisonExternalSnapshotMetaData> metaData = this.getMetaData(name);
        if (metaData.isEmpty()) {
            return Optional.empty();
        }
        List<InstanceComparisonContributionBase> contributions = this.snapshotIndex.getAllSnapshotContributions(metaData.get().snapshotMetaData().getId());
        return Optional.of(InstanceComparisonSnapshotDto.of(metaData.get().snapshotMetaData(), InstanceComparisonSnapshotDto.InstanceComparisonSnapshotContributions.of(contributions)));
    }

    public void deleteSnapshot(String name) throws StorageException {
        InstanceComparisonExternalSnapshotMetaData metaData = this.getMetaData(name).orElseThrow(() -> new IllegalStateException("No external snapshot for name \"" + name + "\" known"));
        this.metaDataIndex.removeValue(name);
        this.snapshotIndex.removeSnapshot(metaData.snapshotMetaData().getId());
    }

    public Optional<InstanceComparisonExternalSnapshotMetaData> getMetaData(String name) throws StorageException {
        CCSMAssert.isNotNull((Object)name, () -> String.format("Expected \"%s\" to be not null", "name"));
        return Optional.ofNullable((InstanceComparisonExternalSnapshotMetaData)this.metaDataIndex.getValue(name));
    }

    public List<InstanceComparisonExternalSnapshotMetaData> getAllMetaData(@Nullable String user) throws StorageException {
        List allMetaData = this.metaDataIndex.getAllEntries().extractSecondList();
        if (user == null) {
            return allMetaData;
        }
        return CollectionUtils.filter((Collection)allMetaData, metaData -> user.equals(metaData.uploadUser()));
    }

    @IndexValueClass
    public record InstanceComparisonExternalSnapshotMetaData(String name, String uploadUser, Instant uploadTime, InstanceComparisonSnapshotMetaData snapshotMetaData) implements Serializable
    {
    }
}

