/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.index.admin.instance_comparison.comparison.ProjectComparisonResult;
import com.teamscale.index.admin.instance_comparison.snapshot.MigrationChanges;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.FindingsComparisonDetailContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.FindingsInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.MetricsComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ProjectComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ProjectConfigurationComparisonContribution;
import com.teamscale.index.migration.finding.ConfigurationOptionReplacement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.TestOnly;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class FindingsComparisonContribution
extends ProjectComparisonContributionBase {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String NON_BLACKLISTED_CATEGORIES_PROPERTY = "nonBlacklistedCategories";
    private static final String TOLERATED_CATEGORIES_PROPERTY = "toleratedCategories";
    private static final String FALSE_POSITIVE_CATEGORIES_PROPERTY = "falsePositiveCategories";
    private static final String DETAIL_PROPERTY = "detail";
    private static final String LINES_OF_CODE_PROPERTY = "linesOfCode";
    @JsonProperty(value="nonBlacklistedCategories")
    private final CounterSet<String> nonBlacklistedCategories;
    @JsonProperty(value="toleratedCategories")
    private final CounterSet<String> toleratedCategories;
    @JsonProperty(value="falsePositiveCategories")
    private final CounterSet<String> falsePositiveCategories;
    @JsonProperty(value="detail")
    private final @Nullable FindingsComparisonDetailContribution detail;
    @JsonIgnore
    private transient @Nullable ObjectNode projectConfiguration;
    @JsonIgnore
    private transient @Nullable String analysisProfileVersion;
    @JsonProperty(value="linesOfCode")
    private @Nullable Integer linesOfCode;

    @JsonCreator
    FindingsComparisonContribution(@JsonProperty(value="contributor") String contributor, @JsonProperty(value="project") String project, @JsonProperty(value="nonBlacklistedCategories") CounterSet<String> nonBlacklistedCategories, @JsonProperty(value="toleratedCategories") CounterSet<String> toleratedCategories, @JsonProperty(value="falsePositiveCategories") CounterSet<String> falsePositiveCategories, @JsonProperty(value="detail") @Nullable FindingsComparisonDetailContribution detail, @JsonProperty(value="linesOfCode") @Nullable Integer linesOfCode) {
        super(contributor, project);
        this.nonBlacklistedCategories = nonBlacklistedCategories;
        this.toleratedCategories = toleratedCategories;
        this.falsePositiveCategories = falsePositiveCategories;
        this.detail = detail;
        this.linesOfCode = linesOfCode;
    }

    @TestOnly
    public FindingsComparisonContribution(String contributor, String project, CounterSet<String> nonBlacklistedCategories, CounterSet<String> toleratedCategories, CounterSet<String> falsePositiveCategories, @Nullable FindingsComparisonDetailContribution detail, @Nullable Integer linesOfCode, @Nullable ObjectNode projectConfiguration, @Nullable String analysisProfileVersion) {
        super(contributor, project);
        this.nonBlacklistedCategories = nonBlacklistedCategories;
        this.toleratedCategories = toleratedCategories;
        this.falsePositiveCategories = falsePositiveCategories;
        this.detail = detail;
        this.linesOfCode = linesOfCode;
        this.analysisProfileVersion = analysisProfileVersion;
        this.projectConfiguration = projectConfiguration;
    }

    public FindingsComparisonContribution(String contributor, String project, int linesOfCode, boolean detailed) {
        super(contributor, project);
        this.nonBlacklistedCategories = new CounterSet();
        this.toleratedCategories = new CounterSet();
        this.falsePositiveCategories = new CounterSet();
        this.detail = detailed ? new FindingsComparisonDetailContribution() : null;
        this.linesOfCode = linesOfCode;
    }

    public void addNonBlacklisted(String category, TrackedFinding finding) {
        this.incNonBlacklisted(category);
        if (this.detail != null) {
            this.detail.addNonBlacklistedFinding(category, finding);
        }
    }

    private void incNonBlacklisted(String category) {
        this.nonBlacklistedCategories.inc((Object)category);
    }

    public void addTolerated(String category, TrackedFinding finding) {
        this.incToleration(category);
        if (this.detail != null) {
            this.detail.addToleratedFinding(category, finding);
        }
    }

    private void incToleration(String category) {
        this.toleratedCategories.inc((Object)category);
    }

    public void addFalsePositive(String category, TrackedFinding finding) {
        this.incFalsePositive(category);
        if (this.detail != null) {
            this.detail.addFalsePositiveFinding(category, finding);
        }
    }

    private void incFalsePositive(String category) {
        this.falsePositiveCategories.inc((Object)category);
    }

    @Override
    public ProjectComparisonResult computeComparisonResult(InstanceComparisonContributionBase other, InstanceComparisonContributionBase.ComparisonContext context) {
        if (other instanceof FindingsComparisonContribution) {
            FindingsComparisonContribution otherFindingsContribution = (FindingsComparisonContribution)other;
            FindingsComparisonContribution.patchRemoteInstanceValues(otherFindingsContribution, context);
        }
        return super.computeComparisonResult(other, context);
    }

    private static void patchRemoteInstanceValues(FindingsComparisonContribution remoteFindingsContribution, InstanceComparisonContributionBase.ComparisonContext context) {
        ProjectComparisonContributionBase remoteMetricsContribution;
        if (remoteFindingsContribution.linesOfCode == null) {
            remoteMetricsContribution = FindingsComparisonContribution.getSiblingContributionOrThrow(context, MetricsComparisonContribution.class);
            remoteFindingsContribution.linesOfCode = FindingsComparisonContribution.getLinesOfCode((MetricsComparisonContribution)remoteMetricsContribution);
        }
        if (remoteFindingsContribution.projectConfiguration == null) {
            remoteMetricsContribution = FindingsComparisonContribution.getSiblingContributionOrThrow(context, ProjectConfigurationComparisonContribution.class);
            remoteFindingsContribution.projectConfiguration = ((ProjectConfigurationComparisonContribution)remoteMetricsContribution).getProjectConfiguration();
            remoteFindingsContribution.analysisProfileVersion = ((ProjectConfigurationComparisonContribution)remoteMetricsContribution).getAnalysisProfileVersion();
        }
    }

    private static <T extends ProjectComparisonContributionBase> T getSiblingContributionOrThrow(InstanceComparisonContributionBase.ComparisonContext context, Class<T> targetClazz) {
        return (T)((ProjectComparisonContributionBase)context.getRemoteContribution(targetClazz).orElseThrow(() -> new NoSuchElementException("Expected the remote snapshot to contain a " + targetClazz.getName())));
    }

    private static int getLinesOfCode(MetricsComparisonContribution remoteMetricsContribution) {
        MetricDirectoryEntry metricDirectoryEntry = remoteMetricsContribution.getEntry();
        if (metricDirectoryEntry == null) {
            LOGGER.warn("Remote Instance: No metrics found for project '{}'. This may be caused by the project being empty.", (Object)remoteMetricsContribution.getProject());
            return 0;
        }
        MetricDirectorySchema schema = remoteMetricsContribution.getSchema();
        if (schema == null) {
            LOGGER.warn("Remote Instance: No metrics schema found for project '{}'. This may be caused by the project being empty.", (Object)remoteMetricsContribution.getProject());
            return 0;
        }
        if (schema.getValuePosition("Lines of Code") < 0) {
            LOGGER.warn("Remote Instance: No metric '{}' found for project '{}'. This may be caused by the '{}' setting in the respective analysis profile.", (Object)"Lines of Code", (Object)remoteMetricsContribution.getProject(), (Object)"Disable LOC metrics");
            return 0;
        }
        return ((Number)metricDirectoryEntry.getValue(schema, "Lines of Code", Number.class)).intValue();
    }

    public Map<String, FindingsInstanceComparisonValue> getValues(InstanceComparisonContributionBase.ComparisonContext context) {
        MigrationChanges migrationChanges = this.collectChangesCausedByMigrations(context.getGlobalStorageSystem());
        HashMap<String, FindingsInstanceComparisonValue> result = new HashMap<String, FindingsInstanceComparisonValue>();
        for (String category : CollectionUtils.unionSet((Collection)this.nonBlacklistedCategories.getKeys(), (Collection[])new Collection[]{this.toleratedCategories.getKeys(), this.falsePositiveCategories.getKeys()})) {
            Object normalizedCategory = category;
            String[] parts = category.split("/");
            if (parts.length != 4) {
                LOGGER.warn("Unexpected category format, expected exactly 4 parts divided by '/', but got {}", (Object)category);
            } else {
                String groupName = parts[1];
                String toolOrGroup = parts[2];
                String checkName = parts[3];
                ConfigurationOptionReplacement renameMigration = (ConfigurationOptionReplacement)migrationChanges.getRenamesByGroupAndOptionName().getValue((Object)groupName, (Object)checkName);
                normalizedCategory = renameMigration != null ? renameMigration.getNewGroupName() + "/" + toolOrGroup + "/" + renameMigration.getNewOptionName() : groupName + "/" + toolOrGroup + "/" + checkName;
                if (FindingsComparisonContribution.isIsDeletedCheckOrOption(migrationChanges, groupName, checkName)) continue;
            }
            if (!((String)normalizedCategory).equals(category)) {
                this.nonBlacklistedCategories.moveValues((Object)category, normalizedCategory);
                this.toleratedCategories.moveValues((Object)category, normalizedCategory);
                this.falsePositiveCategories.moveValues((Object)category, normalizedCategory);
                if (this.detail != null) {
                    this.detail.moveFindings(category, (String)normalizedCategory);
                }
            }
            result.put((String)normalizedCategory, new FindingsInstanceComparisonValue((String)normalizedCategory, this.nonBlacklistedCategories, this.toleratedCategories, this.falsePositiveCategories, this.detail, this.getLinesOfCode(), this.getUnflaggedFindingsCount()));
        }
        return result;
    }

    private static boolean isIsDeletedCheckOrOption(MigrationChanges migrationChanges, String groupName, String checkName) {
        return migrationChanges.getGroupsWithDeletedOptions().stream().anyMatch(groupAndOptionName -> groupName.equals(groupAndOptionName.getFirst()) && checkName.equals(groupAndOptionName.getSecond()));
    }

    protected MigrationChanges collectChangesCausedByMigrations(GlobalStorageSystem globalStorageSystem) {
        return FindingsComparisonContribution.collectMigrationChangesFor(this.projectConfiguration, this.analysisProfileVersion, globalStorageSystem);
    }

    int getUnflaggedFindingsCount() {
        return this.nonBlacklistedCategories.getTotal();
    }

    int getLinesOfCode() {
        if (this.linesOfCode == null) {
            throw new IllegalStateException("linesOfCode was not correctly set");
        }
        return this.linesOfCode;
    }
}

