/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions.project;

import com.teamscale.core.log.parse.ParseLogEntry;
import com.teamscale.core.log.parse.ParseLogIndex;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.IComparisonContributorContext;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.LogErrorsComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ParseLogErrorsComparisonDetailContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ProjectComparisonContributorBase;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CounterSet;

public class ParseLogErrorsComparisonContributor
extends ProjectComparisonContributorBase {
    public static final String PARSE_LOG_CONTRIBUTOR = "Parse Log Errors";

    public ParseLogErrorsComparisonContributor(IComparisonContributorContext.ProjectContext context) {
        super(context);
    }

    @Override
    public LogErrorsComparisonContribution createComparisonInput() throws StorageException {
        List<ParseLogEntry> interestingLogEntries = ((ParseLogIndex)this.getProjectStorageSystem().openProjectIndex(ParseLogIndex.class, null)).getAllParseLogEntries().stream().filter(this::isBeforeEndTimestamp).toList();
        CounterSet pathsWithErrorCount = (CounterSet)interestingLogEntries.stream().map(ParseLogEntry::getUniformPath).collect(CounterSet.toCounterSet());
        ParseLogErrorsComparisonDetailContribution detailContribution = null;
        if (((IComparisonContributorContext.ProjectContext)this.context).detailed()) {
            detailContribution = new ParseLogErrorsComparisonDetailContribution();
            interestingLogEntries.forEach(detailContribution::add);
        }
        return new LogErrorsComparisonContribution(PARSE_LOG_CONTRIBUTOR, ((IComparisonContributorContext.ProjectContext)this.context).publicProjectId().toString(), (CounterSet<String>)pathsWithErrorCount, detailContribution);
    }

    private boolean isBeforeEndTimestamp(ParseLogEntry logEntry) {
        return logEntry.getCommit().getTimestamp() < ((IComparisonContributorContext.ProjectContext)this.context).endTimestamp();
    }
}

